/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;

public class FixedExchangeRateTimeSeries
implements ExchangeRateTimeSeries {
    private ExchangeRateProvider provider;
    private int weight;
    private String baseCurrency;
    private String termCurrency;
    private BigDecimal rate;
    private LocalDate seriesStart;

    public FixedExchangeRateTimeSeries(ExchangeRateProvider provider, int weight, BigDecimal rate, String baseCurrency, String termCurrency) {
        this(provider, weight, rate, baseCurrency, termCurrency, LocalDate.of(2000, 1, 1));
    }

    public FixedExchangeRateTimeSeries(ExchangeRateProvider provider, int weight, BigDecimal rate, String baseCurrency, String termCurrency, LocalDate seriesStart) {
        this.provider = provider;
        this.weight = weight;
        this.rate = rate;
        this.baseCurrency = baseCurrency;
        this.termCurrency = termCurrency;
        this.seriesStart = seriesStart;
    }

    @Override
    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    @Override
    public String getTermCurrency() {
        return this.termCurrency;
    }

    @Override
    public Optional<ExchangeRateProvider> getProvider() {
        return Optional.of(this.provider);
    }

    @Override
    public List<ExchangeRate> getRates() {
        ArrayList<ExchangeRate> answer = new ArrayList<ExchangeRate>();
        answer.add(new ExchangeRate(this.seriesStart, this.rate));
        answer.add(new ExchangeRate(LocalDate.now(), this.rate));
        return answer;
    }

    @Override
    public Optional<ExchangeRate> lookupRate(LocalDate requestedTime) {
        return Optional.of(new ExchangeRate(requestedTime, this.rate));
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

