/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.online.QuoteFeedData;

public interface QuoteFeed {
    public static final String MANUAL = "MANUAL";

    public String getId();

    public String getName();

    default public Optional<String> getHelpURL() {
        return Optional.empty();
    }

    default public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        List<LatestSecurityPrice> prices;
        QuoteFeedData data = this.getHistoricalQuotes(security, false);
        if (!data.getErrors().isEmpty()) {
            PortfolioLog.error(data.getErrors());
        }
        if ((prices = data.getLatestPrices()).isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(prices, new SecurityPrice.ByDate());
        return Optional.of(prices.get(prices.size() - 1));
    }

    public QuoteFeedData getHistoricalQuotes(Security var1, boolean var2);

    default public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.getHistoricalQuotes(security, true);
    }

    default public List<Exchange> getExchanges(Security subject, List<Exception> errors) {
        return Collections.emptyList();
    }
}

