/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.EurostatHICPLabels;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class EurostatHICPQuoteFeed
implements QuoteFeed {
    public static final String ID = "EUROSTATHICP";
    private static final String EUROSTAT_HOST = "ec.europa.eu";
    private static final String EUROSTAT_PAGE = "/eurostat/wdds/rest/data/v2.1/json/en/prc_hicp_midx";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return Messages.LabelEurostatHICP;
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        return Optional.empty();
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        if (security.getTickerSymbol() == null) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgMissingTickerSymbol, security.getName())));
        }
        QuoteFeedData data = new QuoteFeedData();
        try {
            String responseBody = this.requestData(security, collectRawResponse, data);
            this.extractQuotes(responseBody, data);
        }
        catch (IOException | URISyntaxException e) {
            data.addError(new IOException(MessageFormat.format(Messages.MsgErrorDownloadEurostatHICP, 1, security.getTickerSymbol(), e.getMessage()), e));
        }
        return data;
    }

    private String requestData(Security security, boolean collectRawResponse, QuoteFeedData data) throws IOException, URISyntaxException {
        WebAccess webaccess = new WebAccess(EUROSTAT_HOST, EUROSTAT_PAGE).withScheme("http").addParameter("filterNonGeo", "1").addParameter("precision", "1").addParameter("geo", security.getTickerSymbol().toUpperCase()).addParameter("unit", "I15").addParameter("unitLabel", "code").addParameter("coicop", "CP00").addParameter("groupedIndicators", "1").addParameter("shortLabel", "1");
        String text = webaccess.get();
        if (collectRawResponse) {
            data.addResponse(webaccess.getURL(), text);
        }
        return text;
    }

    private void extractQuotes(String responseBody, QuoteFeedData data) {
        try {
            JSONObject responseData = (JSONObject)JSONValue.parse((String)responseBody);
            if (responseData == null) {
                throw new IOException("responseBody");
            }
            JSONObject eurostatValue = (JSONObject)responseData.get((Object)"value");
            JSONObject eurostatDimension = (JSONObject)responseData.get((Object)"dimension");
            JSONObject eurostatTime = (JSONObject)eurostatDimension.get((Object)"time");
            JSONObject eurostatCategory = (JSONObject)eurostatTime.get((Object)"category");
            JSONObject eurostatIndex = (JSONObject)eurostatCategory.get((Object)"index");
            HashMap<String, Double> hicpValues = new HashMap<String, Double>();
            for (Object key : eurostatValue.keySet()) {
                hicpValues.put(key.toString(), this.parseIndex(eurostatValue.get(key).toString()));
            }
            HashMap<String, String> hicpPeriods = new HashMap<String, String>();
            for (Object key : eurostatIndex.keySet()) {
                hicpPeriods.put(eurostatIndex.get(key).toString(), key.toString());
            }
            int ii = 0;
            while (ii < hicpPeriods.size()) {
                String pricePeriod = (String)hicpPeriods.get(Integer.toString(ii));
                LocalDate ts = LocalDate.of(Integer.parseInt(pricePeriod.substring(0, 4)), Integer.parseInt(pricePeriod.substring(5, 7)), 1);
                Double q = (Double)hicpValues.get(Integer.toString(ii));
                if (q != null) {
                    LatestSecurityPrice price = new LatestSecurityPrice();
                    price.setDate(ts);
                    price.setValue(Values.Quote.factorize(q));
                    price.setHigh(-1L);
                    price.setLow(-1L);
                    price.setVolume(-1L);
                    if (price.getValue() > 0L) {
                        data.addPrice(price);
                    }
                }
                ++ii;
            }
        }
        catch (IOException | IllegalArgumentException | IndexOutOfBoundsException | SecurityException e) {
            data.addError(e);
        }
    }

    private Double parseIndex(String text) throws IOException {
        try {
            DecimalFormat fmt = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.ENGLISH));
            Number q = fmt.parse(text);
            return q.doubleValue();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<Exchange> getExchanges(Security subject, List<Exception> errors) {
        ArrayList<Exchange> answer = new ArrayList<Exchange>();
        Enumeration<String> enumeration = EurostatHICPLabels.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            String hicpRegion = key.substring("region.".length());
            answer.add(new Exchange(hicpRegion, EurostatHICPLabels.getString(key)));
        }
        Collections.sort(answer, (r, l) -> r.getName().compareTo(l.getName()));
        return answer;
    }
}

