/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.regex.Pattern;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.PageCache;
import name.abuchen.portfolio.online.impl.variableurl.Factory;
import name.abuchen.portfolio.online.impl.variableurl.urls.VariableURL;
import name.abuchen.portfolio.util.OnlineHelper;
import name.abuchen.portfolio.util.Pair;
import name.abuchen.portfolio.util.TextUtil;
import name.abuchen.portfolio.util.WebAccess;
import org.jsoup.Jsoup;
import org.jsoup.UncheckedIOException;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;

public class HTMLTableQuoteFeed
implements QuoteFeed {
    public static final String ID = "GENERIC_HTML_TABLE";
    private static final Column[] COLUMNS = new Column[]{new DateColumn(), new TimeColumn(), new CloseColumn(), new HighColumn(), new LowColumn()};
    private final PageCache<Pair<String, List<LatestSecurityPrice>>> cache = new PageCache();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return Messages.LabelHTMLTable;
    }

    @Override
    public Optional<String> getHelpURL() {
        return Optional.of("https://help.portfolio-performance.info/kursdaten_laden/#tabelle-auf-einer-webseite");
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        List<LatestSecurityPrice> prices;
        String feedURL = security.getLatestFeed() == null ? security.getFeedURL() : security.getLatestFeedURL();
        QuoteFeedData data = this.internalGetQuotes(security, feedURL, false, false);
        if (!data.getErrors().isEmpty()) {
            PortfolioLog.error(data.getErrors());
        }
        if ((prices = data.getLatestPrices()).isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(prices, new SecurityPrice.ByDate());
        return Optional.of(prices.get(prices.size() - 1));
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        return this.internalGetQuotes(security, security.getFeedURL(), collectRawResponse, false);
    }

    public QuoteFeedData getHistoricalQuotes(String html) {
        QuoteFeedData data = new QuoteFeedData();
        data.addAllPrices(this.parseFromHTML(html, data));
        return data;
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.internalGetQuotes(security, security.getFeedURL(), true, true);
    }

    private QuoteFeedData internalGetQuotes(Security security, String feedURL, boolean collectRawResponse, boolean isPreview) {
        if (feedURL == null || feedURL.length() == 0) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgMissingFeedURL, security.getName())));
        }
        QuoteFeedData data = new QuoteFeedData();
        VariableURL variableURL = Factory.fromString(feedURL);
        variableURL.setSecurity(security);
        TreeSet<SecurityPrice> newPricesByDate = new TreeSet<SecurityPrice>(new SecurityPrice.ByDate());
        long failedAttempts = 0L;
        long maxFailedAttempts = variableURL.getMaxFailedAttempts();
        for (String url : variableURL) {
            Pair<String, List<LatestSecurityPrice>> answer = this.cache.lookup(url);
            if ((answer == null || collectRawResponse && answer.getLeft().isEmpty()) && !(answer = this.parseFromURL(url, collectRawResponse, data)).getRight().isEmpty()) {
                this.cache.put(url, answer);
            }
            if (collectRawResponse) {
                data.addResponse(url, answer.getLeft());
            }
            int sizeBefore = newPricesByDate.size();
            newPricesByDate.addAll((Collection<SecurityPrice>)answer.getRight());
            if (newPricesByDate.size() > sizeBefore) {
                failedAttempts = 0L;
            } else if (++failedAttempts > maxFailedAttempts) break;
            if (isPreview && newPricesByDate.size() >= 100) break;
        }
        data.addAllPrices(newPricesByDate);
        return data;
    }

    protected String getUserAgent() {
        return OnlineHelper.getUserAgent();
    }

    protected Pair<String, List<LatestSecurityPrice>> parseFromURL(String url, boolean collectRawResponse, QuoteFeedData data) {
        try {
            String html = this.getHtml(url);
            Document document = Jsoup.parse((String)html);
            List<LatestSecurityPrice> prices = this.parse(url, document, data);
            return new Pair<String, List<LatestSecurityPrice>>(collectRawResponse ? html : "", prices);
        }
        catch (IOException | URISyntaxException | UncheckedIOException e) {
            data.addError(new IOException(String.valueOf(url) + '\n' + e.getMessage(), e));
            return new Pair<String, List<LatestSecurityPrice>>(String.valueOf(e.getMessage()), Collections.emptyList());
        }
    }

    String getHtml(String url) throws IOException, URISyntaxException {
        return new WebAccess(url).addUserAgent(this.getUserAgent()).get();
    }

    protected List<LatestSecurityPrice> parseFromHTML(String html, QuoteFeedData data) {
        return this.parse("n/a", Jsoup.parse((String)html), data);
    }

    private List<LatestSecurityPrice> parse(String url, Document document, QuoteFeedData data) {
        String language = document.select("html").attr("lang");
        ArrayList<ExtractedPrice> prices = new ArrayList<ExtractedPrice>();
        Elements tables = document.getElementsByTag("table");
        for (Element table : tables) {
            Elements rows;
            int size;
            ArrayList<Spec> specs = new ArrayList<Spec>();
            HeaderInfo headerInfo = this.buildSpecFromTable(table, specs);
            int rowIndex = headerInfo.rowIndex;
            if (!this.isSpecValid(specs) || (size = (rows = table.select("> tbody > tr")).size()) == 0) continue;
            while (rowIndex < size) {
                Element row = (Element)rows.get(rowIndex);
                try {
                    ExtractedPrice price = this.extractPrice(row, specs, language, headerInfo.numberOfHeaderColumns);
                    if (price != null) {
                        prices.add(price);
                    }
                }
                catch (Exception e) {
                    data.addError(new IOException(String.valueOf(url) + '\n' + e.getMessage(), e));
                }
                ++rowIndex;
            }
            break block2;
        }
        if (prices.isEmpty()) {
            data.addError(new IOException(MessageFormat.format(Messages.MsgNoQuotesFoundInHTML, url, Jsoup.clean((String)document.html(), (Whitelist)Whitelist.relaxed()))));
            return Collections.emptyList();
        }
        Collections.sort(prices, (r, l) -> {
            int compare = l.getDate().compareTo(r.getDate());
            if (compare != 0) {
                return compare;
            }
            if (r.getTime() == null || l.getTime() == null) {
                return 0;
            }
            return l.getTime().compareTo(r.getTime());
        });
        ArrayList<LatestSecurityPrice> answer = new ArrayList<LatestSecurityPrice>(prices.size());
        LocalDate last = null;
        for (ExtractedPrice p : prices) {
            if (p.getDate().equals(last)) continue;
            answer.add(p.toLatestSecurityPrice());
            last = p.getDate();
        }
        return answer;
    }

    private HeaderInfo buildSpecFromTable(Element table, List<Spec> specs) {
        Elements header = table.select("> thead > tr > th");
        if (!header.isEmpty()) {
            this.buildSpecFromRow(header, specs);
            if (!specs.isEmpty()) {
                return new HeaderInfo(0, header.size());
            }
        }
        if (!(header = table.select("> thead > tr > td")).isEmpty()) {
            this.buildSpecFromRow(header, specs);
            if (!specs.isEmpty()) {
                return new HeaderInfo(0, header.size());
            }
        }
        if (!(header = table.select("> tbody > tr > th")).isEmpty()) {
            this.buildSpecFromRow(header, specs);
            if (!specs.isEmpty()) {
                return new HeaderInfo(0, header.size());
            }
        }
        int rowIndex = 0;
        Elements rows = table.select("> tbody > tr");
        Elements headerRow = null;
        if (!rows.isEmpty()) {
            Element firstRow = (Element)rows.get(0);
            headerRow = firstRow.select("> td");
            this.buildSpecFromRow(headerRow, specs);
            ++rowIndex;
        }
        if (specs.isEmpty() && rows.size() > 1) {
            Element secondRow = (Element)rows.get(1);
            headerRow = secondRow.select("> td");
            this.buildSpecFromRow(headerRow, specs);
            ++rowIndex;
        }
        return new HeaderInfo(rowIndex, headerRow != null ? headerRow.size() : 0);
    }

    protected Column[] getColumns() {
        return COLUMNS;
    }

    private void buildSpecFromRow(Elements row, List<Spec> specs) {
        HashSet available = new HashSet();
        Collections.addAll(available, this.getColumns());
        int ii = 0;
        while (ii < row.size()) {
            Element element = (Element)row.get(ii);
            if (element.hasAttr("colspan")) {
                int colspan = Integer.valueOf(element.attr("colspan"));
                element.removeAttr("colspan");
                int c = 1;
                while (c < colspan) {
                    row.add(ii, (Object)element);
                    ++c;
                }
            }
            for (Column column : available) {
                if (!column.matches(element)) continue;
                specs.add(new Spec(column, ii));
                available.remove(column);
                break;
            }
            ++ii;
        }
    }

    private boolean isSpecValid(List<Spec> specs) {
        if (specs == null || specs.isEmpty()) {
            return false;
        }
        boolean hasDate = false;
        boolean hasClose = false;
        for (Spec spec : specs) {
            hasDate = hasDate || spec.column instanceof DateColumn || spec.column instanceof TimeColumn;
            boolean bl = hasClose = hasClose || spec.column instanceof CloseColumn;
        }
        return hasDate && hasClose;
    }

    private ExtractedPrice extractPrice(Element row, List<Spec> specs, String languageHint, int numberOfHeaderColumns) throws ParseException {
        Elements cells = row.select("> td");
        if (cells.size() != numberOfHeaderColumns) {
            return null;
        }
        ExtractedPrice price = new ExtractedPrice();
        for (Spec spec : specs) {
            spec.column.setValue((Element)cells.get(spec.index), price, languageHint);
        }
        if (price.getDate() == null) {
            price.setDate(LocalDate.now());
        }
        return price;
    }

    public static void main(String[] args) throws IOException {
        PrintWriter writer = new PrintWriter(System.out);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.charAt(0) != '#') {
                new HTMLTableQuoteFeed().doLoad(arg, writer);
            }
            ++n2;
        }
        writer.flush();
    }

    protected void doLoad(String source, PrintWriter writer) throws IOException {
        Pair<String, List<LatestSecurityPrice>> result;
        writer.println("--------");
        writer.println(source);
        writer.println("--------");
        QuoteFeedData data = new QuoteFeedData();
        if (source.startsWith("http")) {
            result = this.parseFromURL(source, false, data);
        } else {
            Throwable throwable = null;
            Iterator<Object> iterator = null;
            try (Scanner scanner = new Scanner(new File(source), StandardCharsets.UTF_8.name());){
                String html = scanner.useDelimiter("\\A").next();
                result = new Pair<String, List<LatestSecurityPrice>>(html, new HTMLTableQuoteFeed().parseFromHTML(html, data));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        for (Exception error : data.getErrors()) {
            error.printStackTrace(writer);
        }
        for (LatestSecurityPrice p : result.getRight()) {
            writer.print(Values.Date.format(p.getDate()));
            writer.print("\t");
            writer.print(Values.Quote.format(p.getValue()));
            writer.print("\t");
            writer.print(Values.Quote.format(p.getLow()));
            writer.print("\t");
            writer.println(Values.Quote.format(p.getHigh()));
        }
    }

    protected static class CloseColumn
    extends Column {
        public CloseColumn() {
            super(new String[]{"Schluss.*", "Schlu\u00df.*", "R\u00fccknahmepreis.*", "Close.*", "Zuletzt", "Price", "akt. Kurs", "Dernier", "Kurs"});
        }

        public CloseColumn(String[] patterns) {
            super(patterns);
        }

        @Override
        void setValue(Element value, ExtractedPrice price, String languageHint) throws ParseException {
            price.setValue(this.asQuote(value, languageHint));
        }
    }

    protected static abstract class Column {
        static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT_GERMAN = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.###", new DecimalFormatSymbols(Locale.GERMAN)));
        static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT_ENGLISH = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.###", new DecimalFormatSymbols(Locale.ENGLISH)));
        static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT_APOSTROPHE = ThreadLocal.withInitial(() -> {
            DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols(Locale.US);
            unusualSymbols.setGroupingSeparator('\'');
            return new DecimalFormat("#,##0.##", unusualSymbols);
        });
        private final Pattern[] patterns;

        protected Column(String[] strings) {
            this.patterns = new Pattern[strings.length];
            int ii = 0;
            while (ii < strings.length) {
                this.patterns[ii] = Pattern.compile(strings[ii]);
                ++ii;
            }
        }

        protected boolean matches(Element header) {
            String text = TextUtil.strip(header.text());
            Pattern[] patternArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(text).matches()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        abstract void setValue(Element var1, ExtractedPrice var2, String var3) throws ParseException;

        protected long asQuote(Element value, String languageHint) throws ParseException {
            int apostrophe;
            String text = value.text().trim();
            DecimalFormat format = null;
            if ("de".equals(languageHint)) {
                format = DECIMAL_FORMAT_GERMAN.get();
            } else if ("en".equals(languageHint)) {
                format = DECIMAL_FORMAT_ENGLISH.get();
            }
            if (format == null && (apostrophe = text.indexOf(39)) >= 0) {
                format = DECIMAL_FORMAT_APOSTROPHE.get();
            }
            if (format == null) {
                int lastComma;
                int lastDot = text.lastIndexOf(46);
                format = Math.max(lastDot, lastComma = text.lastIndexOf(44)) == lastComma ? DECIMAL_FORMAT_GERMAN.get() : DECIMAL_FORMAT_ENGLISH.get();
            }
            double quote = format.parse(text).doubleValue();
            return Math.round(quote * (double)Values.Quote.factor());
        }
    }

    protected static class DateColumn
    extends Column {
        private DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("y-M-d"), new DateTimeFormatterBuilder().appendPattern("d.M.").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, Year.now().getValue() - 80).toFormatter(), DateTimeFormatter.ofPattern("d.M.y"), DateTimeFormatter.ofPattern("d. MMM y"), DateTimeFormatter.ofPattern("d. MMMM y"), DateTimeFormatter.ofPattern("d. MMM. y"), DateTimeFormatter.ofPattern("MMM d, y", Locale.ENGLISH), DateTimeFormatter.ofPattern("MMM dd, y", Locale.ENGLISH), DateTimeFormatter.ofPattern("MMM dd y", Locale.ENGLISH), DateTimeFormatter.ofPattern("d MMM y", Locale.ENGLISH), DateTimeFormatter.ofPattern("EEEE, MMMM dd, yEEE, MMM dd, y", Locale.ENGLISH)};

        public DateColumn() {
            this(new String[]{"Datum.*", "Date.*"});
        }

        public DateColumn(String[] patterns) {
            super(patterns);
        }

        @Override
        void setValue(Element value, ExtractedPrice price, String languageHint) throws ParseException {
            String text = TextUtil.strip(value.text());
            int ii = 0;
            while (ii < this.formatters.length) {
                try {
                    LocalDate date = LocalDate.parse(text, this.formatters[ii]);
                    price.setDate(date);
                    return;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    ++ii;
                }
            }
            throw new ParseException(text, 0);
        }
    }

    private static class ExtractedPrice
    extends LatestSecurityPrice {
        private LocalTime time;

        private ExtractedPrice() {
        }

        public LocalTime getTime() {
            return this.time;
        }

        public void setTime(LocalTime time) {
            this.time = time;
        }

        public LatestSecurityPrice toLatestSecurityPrice() {
            return new LatestSecurityPrice(this.getDate(), this.getValue(), this.getHigh(), this.getLow(), this.getVolume());
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ExtractedPrice other = (ExtractedPrice)obj;
            return Objects.equals(this.time, other.time);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(this.time);
        }
    }

    private static class HeaderInfo {
        private final int rowIndex;
        private final int numberOfHeaderColumns;

        public HeaderInfo(int rowIndex, int numberOfHeaderColumns) {
            this.rowIndex = rowIndex;
            this.numberOfHeaderColumns = numberOfHeaderColumns;
        }
    }

    protected static class HighColumn
    extends Column {
        public HighColumn() {
            super(new String[]{"Hoch.*", "Tageshoch.*", "Max.*", "High.*"});
        }

        public HighColumn(String[] patterns) {
            super(patterns);
        }

        @Override
        void setValue(Element value, ExtractedPrice price, String languageHint) throws ParseException {
            if ("-".equals(value.text().trim())) {
                price.setHigh(-1L);
            } else {
                price.setHigh(this.asQuote(value, languageHint));
            }
        }
    }

    protected static class LowColumn
    extends Column {
        public LowColumn() {
            super(new String[]{"Tief.*", "Tagestief.*", "Low.*"});
        }

        public LowColumn(String[] patterns) {
            super(patterns);
        }

        @Override
        void setValue(Element value, ExtractedPrice price, String languageHint) throws ParseException {
            if ("-".equals(value.text().trim())) {
                price.setLow(-1L);
            } else {
                price.setLow(this.asQuote(value, languageHint));
            }
        }
    }

    private static class Spec {
        private final Column column;
        private final int index;

        public Spec(Column column, int index) {
            this.column = column;
            this.index = index;
        }
    }

    protected static class TimeColumn
    extends Column {
        private DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_TIME};

        public TimeColumn() {
            super(new String[]{"Zeit.*"});
        }

        @Override
        void setValue(Element value, ExtractedPrice price, String languageHint) throws ParseException {
            String text = TextUtil.strip(value.text());
            DateTimeFormatter[] dateTimeFormatterArray = this.formatters;
            int n = this.formatters.length;
            int n2 = 0;
            while (n2 < n) {
                DateTimeFormatter formatter = dateTimeFormatterArray[n2];
                try {
                    LocalTime time = LocalTime.parse(text, formatter);
                    price.setTime(time);
                    return;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    ++n2;
                }
            }
            throw new ParseException(text, 0);
        }
    }
}

