/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.online.impl.YahooHelper;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.osgi.framework.FrameworkUtil;

public class PortfolioReportNet {
    private static final String TYPE_SHARE = "share";
    private static final String TYPE_BOND = "bond";
    private static final String HOST = "www.portfolio-report.net";

    public List<SecuritySearchProvider.ResultItem> search(String query, SecuritySearchProvider.Type type) throws IOException {
        WebAccess webAccess = new WebAccess(HOST, "/api/securities/search/" + query).addUserAgent("PortfolioPerformance/" + FrameworkUtil.getBundle(PortfolioReportNet.class).getVersion().toString());
        switch (type) {
            case SHARE: {
                webAccess.addParameter("securityType", TYPE_SHARE);
                break;
            }
            case BOND: {
                webAccess.addParameter("securityType", TYPE_BOND);
            }
        }
        return this.readItems(webAccess.get());
    }

    public Optional<SecuritySearchProvider.ResultItem> getUpdatedValues(String onlineId) throws IOException {
        String html = new WebAccess(HOST, "/api/securities/uuid/" + onlineId).addUserAgent("PortfolioPerformance/" + FrameworkUtil.getBundle(PortfolioReportNet.class).getVersion().toString()).addHeader("X-Source", "Portfolio Peformance " + FrameworkUtil.getBundle(PortfolioReportNet.class).getVersion().toString()).addHeader("X-Reason", "periodic update").addHeader("Content-Type", "application/json;chartset=UTF-8").get();
        Optional<SecuritySearchProvider.ResultItem> onlineItem = Optional.empty();
        JSONObject response = (JSONObject)JSONValue.parse((String)html);
        if (response != null) {
            onlineItem = Optional.of(OnlineItem.from(response));
        }
        return onlineItem;
    }

    private List<SecuritySearchProvider.ResultItem> readItems(String html) {
        ArrayList<SecuritySearchProvider.ResultItem> onlineItems = new ArrayList<SecuritySearchProvider.ResultItem>();
        JSONArray response = (JSONArray)JSONValue.parse((String)html);
        if (response != null) {
            int ii = 0;
            while (ii < response.size()) {
                onlineItems.add(OnlineItem.from((JSONObject)response.get(ii)));
                ++ii;
            }
        }
        return onlineItems;
    }

    public static boolean updateWith(Security security, SecuritySearchProvider.ResultItem item) {
        if (!(item instanceof OnlineItem)) {
            throw new IllegalArgumentException();
        }
        return ((OnlineItem)item).update(security);
    }

    static class MarketInfo {
        private String marketCode;
        private String currencyCode;
        private LocalDate firstPriceDate;
        private LocalDate lastPriceDate;

        static List<MarketInfo> from(JSONArray json) {
            if (json == null) {
                return Collections.emptyList();
            }
            ArrayList<MarketInfo> answer = new ArrayList<MarketInfo>();
            for (Object obj : json) {
                JSONObject market = (JSONObject)obj;
                MarketInfo info = new MarketInfo();
                info.marketCode = (String)market.get((Object)"marketCode");
                info.currencyCode = (String)market.get((Object)"currencyCode");
                info.firstPriceDate = YahooHelper.fromISODate((String)market.get((Object)"firstPriceDate"));
                info.lastPriceDate = YahooHelper.fromISODate((String)market.get((Object)"lastPriceDate"));
                answer.add(info);
            }
            return answer;
        }

        private MarketInfo() {
        }

        public String getMarketCode() {
            return this.marketCode;
        }

        public String getCurrencyCode() {
            return this.currencyCode;
        }

        public LocalDate getFirstPriceDate() {
            return this.firstPriceDate;
        }

        public LocalDate getLastPriceDate() {
            return this.lastPriceDate;
        }
    }

    static class OnlineItem
    implements SecuritySearchProvider.ResultItem {
        private String id;
        private String name;
        private String type;
        private String isin;
        private String wkn;
        private List<SymbolInfo> symbols;
        private List<MarketInfo> markets;

        static OnlineItem from(JSONObject jsonObject) {
            OnlineItem vehicle = new OnlineItem();
            vehicle.id = (String)jsonObject.get((Object)"uuid");
            vehicle.name = (String)jsonObject.get((Object)"name");
            String t = (String)jsonObject.get((Object)"securityType");
            vehicle.type = PortfolioReportNet.TYPE_SHARE.equals(t) ? SecuritySearchProvider.Type.SHARE.toString() : (PortfolioReportNet.TYPE_BOND.equals(t) ? SecuritySearchProvider.Type.BOND.toString() : t);
            vehicle.isin = (String)jsonObject.get((Object)"isin");
            vehicle.wkn = (String)jsonObject.get((Object)"wkn");
            vehicle.symbols = SymbolInfo.from(jsonObject);
            vehicle.markets = MarketInfo.from((JSONArray)jsonObject.get((Object)"markets"));
            return vehicle;
        }

        private OnlineItem() {
        }

        @Override
        public String getOnlineId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getIsin() {
            return this.isin;
        }

        @Override
        public String getWkn() {
            return this.wkn;
        }

        @Override
        public String getSymbol() {
            return this.symbols.stream().map(SymbolInfo::getSymbol).reduce((r, l) -> String.valueOf(r) + "," + l).orElse(null);
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getExchange() {
            return null;
        }

        @Override
        public boolean hasPrices() {
            return !this.markets.isEmpty();
        }

        @Override
        public Security create(ClientSettings settings) {
            Security security = new Security();
            security.setOnlineId(this.id);
            security.setName(this.name);
            security.setIsin(this.isin);
            security.setWkn(this.wkn);
            security.setTickerSymbol(this.symbols.stream().map(SymbolInfo::getSymbol).findAny().orElse(null));
            this.symbols.forEach(symbolInfo -> security.addProperty(new SecurityProperty(SecurityProperty.Type.MARKET, symbolInfo.getExchange(), symbolInfo.getSymbol())));
            security.setPropertyValue(SecurityProperty.Type.FEED, "PORTFOLIO-REPORT-MARKETS", this.markets.isEmpty() ? null : new Gson().toJson(this.markets));
            if (!this.markets.isEmpty()) {
                security.setFeed("PORTFOLIO-REPORT");
                security.setPropertyValue(SecurityProperty.Type.FEED, "PORTFOLIO-REPORT-MARKET", this.markets.get(0).getMarketCode());
            }
            return security;
        }

        public boolean update(Security security) {
            boolean isDirty = false;
            if (!Objects.equals(this.isin, security.getIsin())) {
                security.setIsin(this.isin);
                isDirty = true;
            }
            if (!Objects.equals(this.wkn, security.getWkn())) {
                security.setWkn(this.wkn);
                isDirty = true;
            }
            List local = security.getProperties().filter(property -> property.getType() == SecurityProperty.Type.MARKET).collect(Collectors.toList());
            Map<String, String> remote = this.symbols.stream().collect(Collectors.toMap(SymbolInfo::getExchange, SymbolInfo::getSymbol));
            for (SecurityProperty property2 : local) {
                String symbol = remote.remove(property2.getName());
                if (symbol == null) {
                    security.removeProperty(property2);
                    isDirty = true;
                    continue;
                }
                if (symbol.equals(property2.getValue())) continue;
                security.removeProperty(property2);
                security.addProperty(new SecurityProperty(SecurityProperty.Type.MARKET, property2.getName(), symbol));
                isDirty = true;
            }
            remote.forEach((k, v) -> security.addProperty(new SecurityProperty(SecurityProperty.Type.MARKET, (String)k, (String)v)));
            if (security.setPropertyValue(SecurityProperty.Type.FEED, "PORTFOLIO-REPORT-MARKETS", this.markets.isEmpty() ? null : new Gson().toJson(this.markets))) {
                isDirty = true;
            }
            return isDirty || !remote.isEmpty();
        }
    }

    static class SymbolInfo {
        private static final String SYMBOL_KEY = "symbol";
        private String exchange;
        private String symbol;

        static List<SymbolInfo> from(JSONObject json) {
            if (json == null) {
                return Collections.emptyList();
            }
            Set set = json.entrySet();
            return set.stream().filter(entry -> entry.getKey().toString().startsWith(SYMBOL_KEY)).map(entry -> {
                SymbolInfo m = new SymbolInfo();
                String key = entry.getKey().toString();
                m.exchange = key.substring(SYMBOL_KEY.length()).toUpperCase(Locale.US);
                m.symbol = entry.getValue() == null ? null : entry.getValue().toString();
                return m;
            }).filter(m -> m.getSymbol() != null && !m.getSymbol().isEmpty()).collect(Collectors.toList());
        }

        private SymbolInfo() {
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

