/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.ExchangeLabels;
import name.abuchen.portfolio.online.impl.YahooHelper;
import name.abuchen.portfolio.online.impl.YahooSymbolSearch;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class YahooFinanceQuoteFeed
implements QuoteFeed {
    public static final String ID = "YAHOO";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return Messages.LabelYahooFinance;
    }

    public String rpcLatestQuote(Security security) throws IOException {
        return new WebAccess("query1.finance.yahoo.com", "/v7/finance/quote").addParameter("lang", "en-US").addParameter("region", "US").addParameter("corsDomain", "finance.yahoo.com").addParameter("symbols", security.getTickerSymbol()).get();
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        try {
            Optional<String> volume;
            Optional<String> low;
            Optional<String> high;
            Optional<String> previousClose;
            Optional<String> value;
            String html = this.rpcLatestQuote(security);
            int startIndex = html.indexOf("quoteResponse");
            if (startIndex < 0) {
                return Optional.empty();
            }
            LatestSecurityPrice price = new LatestSecurityPrice();
            Optional<String> time = this.extract(html, startIndex, "\"regularMarketTime\":", ",");
            if (time.isPresent()) {
                long epoch = Long.parseLong(time.get());
                price.setDate(Instant.ofEpochSecond(epoch).atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if ((value = this.extract(html, startIndex, "\"regularMarketPrice\":", ",")).isPresent()) {
                price.setValue(YahooHelper.asPrice(value.get()));
            }
            if ((previousClose = this.extract(html, startIndex, "\"regularMarketPreviousClose\":", ",")).isPresent()) {
                price.setPreviousClose(YahooHelper.asPrice(previousClose.get()));
            }
            if ((high = this.extract(html, startIndex, "\"regularMarketDayHigh\":", ",")).isPresent()) {
                price.setHigh(YahooHelper.asPrice(high.get()));
            }
            if ((low = this.extract(html, startIndex, "\"regularMarketDayLow\":", ",")).isPresent()) {
                price.setLow(YahooHelper.asPrice(low.get()));
            }
            if ((volume = this.extract(html, startIndex, "\"regularMarketVolume\":", ",")).isPresent()) {
                price.setVolume(YahooHelper.asNumber(volume.get()));
            }
            if (price.getDate() == null || price.getValue() <= 0L) {
                PortfolioLog.error(html);
                return Optional.empty();
            }
            return Optional.of(price);
        }
        catch (IOException | ParseException e) {
            PortfolioLog.error(e);
            return Optional.empty();
        }
    }

    private Optional<String> extract(String body, int startIndex, String startToken, String endToken) {
        int begin = body.indexOf(startToken, startIndex);
        if (begin < 0) {
            return Optional.empty();
        }
        int end = body.indexOf(endToken, begin + startToken.length());
        if (end < 0) {
            return Optional.empty();
        }
        return Optional.of(body.substring(begin + startToken.length(), end));
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        LocalDate start = this.caculateStart(security);
        return this.internalGetQuotes(security, start);
    }

    final LocalDate caculateStart(Security security) {
        if (!security.getPrices().isEmpty()) {
            SecurityPrice lastHistoricalQuote = security.getPrices().get(security.getPrices().size() - 1);
            return lastHistoricalQuote.getDate();
        }
        return LocalDate.of(1900, 1, 1);
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.internalGetQuotes(security, LocalDate.now().minusMonths(2L));
    }

    private QuoteFeedData internalGetQuotes(Security security, LocalDate startDate) {
        if (security.getTickerSymbol() == null) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgMissingTickerSymbol, security.getName())));
        }
        try {
            String responseBody = this.requestData(security, startDate);
            return this.extractQuotes(responseBody);
        }
        catch (IOException e) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgErrorDownloadYahoo, 1, security.getTickerSymbol(), e.getMessage()), e));
        }
    }

    private String requestData(Security security, LocalDate startDate) throws IOException {
        int days = Dates.daysBetween(startDate, LocalDate.now());
        String range = "10y";
        if (days < 25) {
            range = "1mo";
        } else if (days < 75) {
            range = "3mo";
        } else if (days < 150) {
            range = "6mo";
        } else if (days < 300) {
            range = "1y";
        } else if (days < 600) {
            range = "2y";
        } else if (days < 1500) {
            range = "5y";
        }
        return new WebAccess("query1.finance.yahoo.com", "/v8/finance/chart/" + security.getTickerSymbol()).addParameter("range", range).addParameter("interval", "1d").get();
    }

    QuoteFeedData extractQuotes(String responseBody) {
        ArrayList<LatestSecurityPrice> answer = new ArrayList<LatestSecurityPrice>();
        try {
            JSONObject responseData = (JSONObject)JSONValue.parse((String)responseBody);
            if (responseData == null) {
                throw new IOException("responseBody");
            }
            JSONObject resultSet = (JSONObject)responseData.get((Object)"chart");
            if (resultSet == null) {
                throw new IOException("chart");
            }
            JSONArray result = (JSONArray)resultSet.get((Object)"result");
            if (result == null || result.isEmpty()) {
                throw new IOException("result");
            }
            JSONObject result0 = (JSONObject)result.get(0);
            if (result0 == null) {
                throw new IOException("result[0]");
            }
            JSONArray timestamp = (JSONArray)result0.get((Object)"timestamp");
            JSONObject indicators = (JSONObject)result0.get((Object)"indicators");
            if (indicators == null) {
                throw new IOException("indicators");
            }
            JSONArray quotes = this.extractQuotesArray(indicators);
            int size = quotes.size();
            int index = 0;
            while (index < size) {
                Long ts = (Long)timestamp.get(index);
                Double q = (Double)quotes.get(index);
                if (ts != null && q != null && q > 0.0) {
                    LatestSecurityPrice price = new LatestSecurityPrice();
                    price.setDate(LocalDateTime.ofEpochSecond(ts, 0, ZoneOffset.UTC).toLocalDate());
                    double v = (double)Math.round(q * 10000.0) / 10000.0;
                    price.setValue(Values.Quote.factorize(v));
                    answer.add(price);
                }
                ++index;
            }
        }
        catch (IOException | IllegalArgumentException | IndexOutOfBoundsException e) {
            return QuoteFeedData.withError(e);
        }
        QuoteFeedData data = new QuoteFeedData();
        data.getLatestPrices().addAll(answer);
        data.addResponse("n/a", responseBody);
        return data;
    }

    protected JSONArray extractQuotesArray(JSONObject indicators) throws IOException {
        JSONArray quotes = (JSONArray)indicators.get((Object)"quote");
        if (quotes == null || quotes.isEmpty()) {
            throw new IOException("quote");
        }
        JSONObject quote = (JSONObject)quotes.get(0);
        if (quote == null) {
            throw new IOException();
        }
        JSONArray close = (JSONArray)quote.get((Object)"close");
        if (close == null || close.isEmpty()) {
            throw new IOException("close");
        }
        return close;
    }

    @Override
    public final List<Exchange> getExchanges(Security subject, List<Exception> errors) {
        ArrayList<Exchange> answer = new ArrayList<Exchange>();
        List markets = subject.getProperties().filter(p -> p.getType() == SecurityProperty.Type.MARKET).collect(Collectors.toList());
        markets.stream().map(p -> {
            Exchange exchange = new Exchange(p.getValue(), ExchangeLabels.getString("portfolio-report." + p.getName()));
            if ("XFRA".equals(p.getName())) {
                exchange.setId(String.valueOf(exchange.getId()) + ".F");
            }
            return exchange;
        }).forEach(answer::add);
        HashSet<String> candidates = new HashSet<String>();
        answer.forEach(e -> {
            boolean bl = candidates.add(e.getId());
        });
        String symbol = subject.getTickerSymbol();
        if (symbol != null && !symbol.isEmpty()) {
            candidates.add(symbol);
        }
        for (String candidate : candidates) {
            this.searchExchanges(candidate, answer, errors);
        }
        if (symbol != null && !symbol.isEmpty()) {
            Optional<Exchange> defaultExchange = answer.stream().filter(e -> e.getId().equals(subject.getTickerSymbol())).findAny();
            if (!defaultExchange.isPresent()) {
                answer.add(new Exchange(subject.getTickerSymbol(), subject.getTickerSymbol()));
            }
            if (answer.isEmpty()) {
                answer.add(this.createExchange(subject.getTickerSymbol()));
            }
        }
        Collections.sort(answer, (r, l) -> r.getId().compareTo(l.getId()));
        return answer;
    }

    private void searchExchanges(String candidate, List<Exchange> answer, List<Exception> errors) {
        int p = candidate.indexOf(46);
        String prefix = p >= 0 ? candidate.substring(0, p + 1) : String.valueOf(candidate) + ".";
        HashSet duplicates = new HashSet();
        answer.forEach(e -> {
            boolean bl = duplicates.add(e.getId());
        });
        try {
            this.searchSymbols(prefix).filter(r -> !duplicates.contains(r.getSymbol())).map(r -> this.createExchange(r.getSymbol())).forEach(e -> {
                duplicates.add(e.getId());
                answer.add((Exchange)e);
            });
        }
        catch (IOException e2) {
            errors.add(e2);
        }
    }

    private Exchange createExchange(String symbol) {
        int e = symbol.indexOf(46);
        String exchange = e >= 0 ? symbol.substring(e) : ".default";
        String label = ExchangeLabels.getString("yahoo" + exchange);
        return new Exchange(symbol, label);
    }

    protected BufferedReader openReader(String url, List<Exception> errors) {
        try {
            return new BufferedReader(new InputStreamReader(this.openStream(url)));
        }
        catch (IOException e) {
            errors.add(e);
            return null;
        }
    }

    protected InputStream openStream(String wknUrl) throws IOException {
        return new URL(wknUrl).openStream();
    }

    protected Stream<YahooSymbolSearch.Result> searchSymbols(String query) throws IOException {
        return new YahooSymbolSearch().search(query);
    }
}

