/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.online.impl.YahooSymbolSearch;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class YahooSearchProvider
implements SecuritySearchProvider {
    @Override
    public String getName() {
        return Messages.LabelYahooFinance;
    }

    @Override
    public List<SecuritySearchProvider.ResultItem> search(String query, SecuritySearchProvider.Type type) throws IOException {
        List<SecuritySearchProvider.ResultItem> answer = new ArrayList<SecuritySearchProvider.ResultItem>();
        this.addSearchPage(answer, query);
        this.addSymbolSearchResults(answer, query);
        if (type == SecuritySearchProvider.Type.SHARE) {
            answer = answer.stream().filter(r -> "Aktie".equals(r.getType())).collect(Collectors.toList());
        }
        if (type == SecuritySearchProvider.Type.BOND) {
            answer = answer.stream().filter(r -> "Anleihe".equals(r.getType())).collect(Collectors.toList());
        }
        if (answer.size() >= 10) {
            YahooSymbolSearch.Result item = new YahooSymbolSearch.Result(Messages.MsgMoreResultsAvailable);
            answer.add(item);
        }
        return answer;
    }

    private void addSymbolSearchResults(List<SecuritySearchProvider.ResultItem> answer, String query) throws IOException {
        Set existingSymbols = answer.stream().map(SecuritySearchProvider.ResultItem::getSymbol).collect(Collectors.toSet());
        new YahooSymbolSearch().search(query).filter(r -> !existingSymbols.contains(r.getSymbol())).forEach(answer::add);
    }

    private void addSearchPage(List<SecuritySearchProvider.ResultItem> answer, String query) throws IOException {
        String templateURL = "/_finance_doubledown/api/resource/searchassist;searchTerm={0}";
        String url = MessageFormat.format(templateURL, URLEncoder.encode(query, StandardCharsets.UTF_8.name()));
        String html = new WebAccess("de.finance.yahoo.com", url).addParameter("bkt", "finance-DE-de-DE-def").addParameter("device", "desktop").addParameter("intl", "de").addParameter("lang", "de-DE").addParameter("partner", "none").addParameter("region", "DE").addParameter("site", "finance").addParameter("tz", "Europe%2FBerlin").addParameter("ver", "0.102.1312").addParameter("returnMeta", "true").get();
        this.extractFrom(answer, html);
    }

    void extractFrom(List<SecuritySearchProvider.ResultItem> answer, String html) {
        JSONArray items;
        JSONObject data;
        JSONObject response = (JSONObject)JSONValue.parse((String)html);
        if (response != null && (data = (JSONObject)response.get((Object)"data")) != null && (items = (JSONArray)data.get((Object)"items")) != null) {
            int ii = 0;
            while (ii < items.size()) {
                JSONObject item = (JSONObject)items.get(ii);
                answer.add(YahooSymbolSearch.Result.from(item));
                ++ii;
            }
        }
    }
}

