/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import name.abuchen.portfolio.snapshot.PerformanceIndex;

public class Aggregation {
    public static PerformanceIndex aggregate(PerformanceIndex index, Period period) {
        LocalDate[] dates = index.getDates();
        double[] accumulated = index.getAccumulatedPercentage();
        double[] delta = index.getDeltaPercentage();
        long[] inboundTransferals = index.getInboundTransferals();
        long[] outboundTransferals = index.getOutboundTransferals();
        long[] totals = index.getTotals();
        LocalDate start = period.getStartDateFor(dates[0]).plus(period.getPeriod());
        LocalDate kill = start.minusDays(1L);
        ArrayList<LocalDate> cDates = new ArrayList<LocalDate>();
        ArrayList<Double> cAccumulated = new ArrayList<Double>();
        ArrayList<Double> cDelta = new ArrayList<Double>();
        ArrayList<Long> cInboundTransferals = new ArrayList<Long>();
        ArrayList<Long> cOutboundTransferals = new ArrayList<Long>();
        ArrayList<Long> cTotals = new ArrayList<Long>();
        double d = 0.0;
        long in_t = 0L;
        long out_t = 0L;
        int ii = 0;
        while (ii < dates.length) {
            LocalDate current = dates[ii];
            d = (d + 1.0) * (delta[ii] + 1.0) - 1.0;
            in_t += inboundTransferals[ii];
            out_t += outboundTransferals[ii];
            if (current.equals(kill) || ii == dates.length - 1) {
                cDates.add(current);
                cAccumulated.add(accumulated[ii]);
                cDelta.add(d);
                cInboundTransferals.add(in_t);
                cOutboundTransferals.add(out_t);
                cTotals.add(totals[ii]);
                d = 0.0;
                in_t = 0L;
                out_t = 0L;
                start = start.plus(period.getPeriod());
                kill = start.minusDays(1L);
            }
            ++ii;
        }
        PerformanceIndex answer = new PerformanceIndex(index.getClient(), index.getCurrencyConverter(), index.getReportInterval());
        answer.dates = cDates.toArray(new LocalDate[0]);
        answer.accumulated = Aggregation.asArrayD(cAccumulated);
        answer.delta = Aggregation.asArrayD(cDelta);
        answer.inboundTransferals = Aggregation.asArrayL(cInboundTransferals);
        answer.outboundTransferals = Aggregation.asArrayL(cOutboundTransferals);
        answer.totals = Aggregation.asArrayL(cTotals);
        return answer;
    }

    private static double[] asArrayD(List<Double> cAccumulated) {
        double[] answer = new double[cAccumulated.size()];
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = cAccumulated.get(ii);
            ++ii;
        }
        return answer;
    }

    private static long[] asArrayL(List<Long> cAccumulated) {
        long[] answer = new long[cAccumulated.size()];
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = cAccumulated.get(ii);
            ++ii;
        }
        return answer;
    }

    public static enum Period {
        WEEKLY{

            @Override
            public TemporalAmount getPeriod() {
                return java.time.Period.ofDays(7);
            }

            @Override
            public LocalDate getStartDateFor(LocalDate d) {
                TemporalField fieldISO = WeekFields.of(Locale.getDefault()).dayOfWeek();
                return d.with(fieldISO, 1L);
            }
        }
        ,
        MONTHLY{

            @Override
            public TemporalAmount getPeriod() {
                return java.time.Period.ofMonths(1);
            }

            @Override
            public LocalDate getStartDateFor(LocalDate d) {
                return d.withDayOfMonth(1);
            }
        }
        ,
        QUARTERLY{

            @Override
            public TemporalAmount getPeriod() {
                return java.time.Period.ofMonths(3);
            }

            @Override
            public LocalDate getStartDateFor(LocalDate d) {
                int month = (d.getMonthValue() - 1) / 3 * 3 + 1;
                return LocalDate.of(d.getYear(), month, 1);
            }
        }
        ,
        YEARLY{

            @Override
            public TemporalAmount getPeriod() {
                return java.time.Period.ofYears(1);
            }

            @Override
            public LocalDate getStartDateFor(LocalDate d) {
                return d.withDayOfYear(1);
            }
        };

        private static final ResourceBundle RESOURCES;

        static {
            RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.snapshot.labels");
        }

        public abstract TemporalAmount getPeriod();

        public abstract LocalDate getStartDateFor(LocalDate var1);

        public String toString() {
            return RESOURCES.getString("aggregation." + this.name());
        }
    }
}

