/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.util.Comparator;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.snapshot.SecurityPosition;

public class AssetPosition {
    private final SecurityPosition position;
    private final CurrencyConverter converter;
    private final LocalDate date;
    private final Money totalAssets;
    private final Money valuation;

    AssetPosition(SecurityPosition position, CurrencyConverter converter, LocalDate date, Money totalAssets) {
        this.position = position;
        this.converter = converter;
        this.date = date;
        this.totalAssets = totalAssets;
        this.valuation = position.calculateValue();
    }

    public Money getValuation() {
        return this.converter.convert(this.date, this.valuation);
    }

    public double getShare() {
        return (double)this.getValuation().getAmount() / (double)this.totalAssets.getAmount();
    }

    public String getDescription() {
        return this.position.getInvestmentVehicle().getName();
    }

    public Security getSecurity() {
        return this.position.getSecurity();
    }

    public SecurityPosition getPosition() {
        return this.position;
    }

    public InvestmentVehicle getInvestmentVehicle() {
        return this.position.getInvestmentVehicle();
    }

    public String toString() {
        return "AssetPosition [" + this.position.getInvestmentVehicle() + ", date=" + this.date + ", valuation=" + this.valuation + "]";
    }

    public static final class ByDescription
    implements Comparator<AssetPosition> {
        @Override
        public int compare(AssetPosition p1, AssetPosition p2) {
            return p1.getDescription().compareToIgnoreCase(p2.getDescription());
        }
    }
}

