/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.Interval;

class ClientIndex
extends PerformanceIndex {
    ClientIndex(Client client, CurrencyConverter converter, Interval reportInterval) {
        super(client, converter, reportInterval);
    }

    void calculate(List<Exception> warnings) {
        Interval interval = this.getReportInterval();
        if (interval.getEnd().isAfter(LocalDate.now())) {
            LocalDate end;
            LocalDate start = interval.getStart();
            if (start.isAfter(end = LocalDate.now())) {
                start = end;
            }
            interval = Interval.of(start, end);
        }
        int size = Math.max(1, (int)interval.getDays() + 1);
        this.dates = new LocalDate[size];
        this.totals = new long[size];
        this.delta = new double[size];
        this.accumulated = new double[size];
        this.inboundTransferals = new long[size];
        this.outboundTransferals = new long[size];
        this.taxes = new long[size];
        this.dividends = new long[size];
        this.interest = new long[size];
        this.interestCharge = new long[size];
        this.buys = new long[size];
        this.sells = new long[size];
        this.collectTransferalsAndTaxes(interval);
        this.dates[0] = interval.getStart();
        this.delta[0] = 0.0;
        this.accumulated[0] = 0.0;
        ClientSnapshot snapshot = ClientSnapshot.create(this.getClient(), this.getCurrencyConverter(), this.dates[0]);
        long valuation = this.totals[0] = snapshot.getMonetaryAssets().getAmount();
        int index = 1;
        LocalDate date = interval.getStart().plusDays(1L);
        while (date.compareTo(interval.getEnd()) <= 0) {
            this.dates[index] = date;
            snapshot = ClientSnapshot.create(this.getClient(), this.getCurrencyConverter(), this.dates[index]);
            long thisValuation = this.totals[index] = snapshot.getMonetaryAssets().getAmount();
            if (valuation + this.inboundTransferals[index] == 0L) {
                this.delta[index] = 0.0;
                long thisDelta = thisValuation - this.inboundTransferals[index] + this.outboundTransferals[index] - valuation;
                if (thisDelta != 0L) {
                    warnings.add(new RuntimeException(MessageFormat.format(Messages.MsgDeltaWithoutAssets, Values.Amount.format(thisDelta), date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)))));
                }
            } else {
                this.delta[index] = (double)(thisValuation + this.outboundTransferals[index]) / (double)(valuation + this.inboundTransferals[index]) - 1.0;
            }
            this.accumulated[index] = (this.accumulated[index - 1] + 1.0) * (this.delta[index] + 1.0) - 1.0;
            date = date.plusDays(1L);
            valuation = thisValuation;
            ++index;
        }
    }

    protected void addValue(long[] array, String currencyCode, long value, Interval interval, LocalDate time) {
        if (value == 0L) {
            return;
        }
        int ii = Dates.daysBetween(interval.getStart(), time);
        if (!currencyCode.equals(this.getCurrencyConverter().getTermCurrency())) {
            int n = ii;
            array[n] = array[n] + this.getCurrencyConverter().convert(time, Money.of(currencyCode, value)).getAmount();
        } else {
            int n = ii;
            array[n] = array[n] + value;
        }
    }

    private void collectTransferalsAndTaxes(Interval interval) {
        for (Account account : this.getClient().getAccounts()) {
            account.getTransactions().stream().filter(t -> !t.getDateTime().toLocalDate().isBefore(interval.getStart()) && !t.getDateTime().toLocalDate().isAfter(interval.getEnd())).forEach(t -> {
                LocalDate d = t.getDateTime().toLocalDate();
                switch (t.getType()) {
                    case DEPOSIT: {
                        this.addValue(this.inboundTransferals, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case REMOVAL: {
                        this.addValue(this.outboundTransferals, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case TAXES: {
                        this.addValue(this.taxes, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case TAX_REFUND: {
                        this.addValue(this.taxes, t.getCurrencyCode(), -t.getAmount(), interval, d);
                        break;
                    }
                    case DIVIDENDS: {
                        this.addValue(this.taxes, t.getCurrencyCode(), t.getUnitSum(Transaction.Unit.Type.TAX).getAmount(), interval, d);
                        this.addValue(this.dividends, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case INTEREST: {
                        this.addValue(this.interest, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case INTEREST_CHARGE: {
                        this.addValue(this.interest, t.getCurrencyCode(), -t.getAmount(), interval, d);
                        this.addValue(this.interestCharge, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                }
            });
        }
        for (Portfolio portfolio : this.getClient().getPortfolios()) {
            portfolio.getTransactions().stream().filter(t -> !t.getDateTime().toLocalDate().isBefore(interval.getStart()) && !t.getDateTime().toLocalDate().isAfter(interval.getEnd())).forEach(t -> {
                LocalDate d = t.getDateTime().toLocalDate();
                this.addValue(this.taxes, t.getCurrencyCode(), t.getUnitSum(Transaction.Unit.Type.TAX).getAmount(), interval, d);
                switch (t.getType()) {
                    case DELIVERY_INBOUND: {
                        this.addValue(this.inboundTransferals, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case DELIVERY_OUTBOUND: {
                        this.addValue(this.outboundTransferals, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case BUY: {
                        this.addValue(this.buys, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                    case SELL: {
                        this.addValue(this.sells, t.getCurrencyCode(), t.getAmount(), interval, d);
                        break;
                    }
                }
            });
        }
    }
}

