/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.snapshot.AccountSnapshot;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.snapshot.GroupByTaxonomy;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyAccount;

public class ClientSnapshot {
    private final CurrencyConverter converter;
    private final LocalDate date;
    private List<AccountSnapshot> accounts = new ArrayList<AccountSnapshot>();
    private List<PortfolioSnapshot> portfolios = new ArrayList<PortfolioSnapshot>();
    private PortfolioSnapshot jointPortfolio;
    private Money assets;

    public static ClientSnapshot create(Client client, CurrencyConverter converter, LocalDate date) {
        ClientSnapshot snapshot = new ClientSnapshot(converter, date);
        for (Account account : client.getAccounts()) {
            snapshot.accounts.add(AccountSnapshot.create(account, converter, date));
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            snapshot.portfolios.add(PortfolioSnapshot.create(portfolio, converter, date));
        }
        return snapshot;
    }

    private ClientSnapshot(CurrencyConverter converter, LocalDate date) {
        this.converter = converter;
        this.date = date;
    }

    public String getCurrencyCode() {
        return this.converter.getTermCurrency();
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public LocalDate getTime() {
        return this.date;
    }

    public List<AccountSnapshot> getAccounts() {
        return this.accounts;
    }

    public List<PortfolioSnapshot> getPortfolios() {
        return this.portfolios;
    }

    public PortfolioSnapshot getJointPortfolio() {
        if (this.jointPortfolio == null) {
            if (this.portfolios.isEmpty()) {
                Portfolio portfolio = new Portfolio();
                portfolio.setName(Messages.LabelJointPortfolio);
                portfolio.setReferenceAccount(new Account(Messages.LabelJointPortfolio));
                this.jointPortfolio = PortfolioSnapshot.create(portfolio, this.converter, this.date);
            } else {
                this.jointPortfolio = this.portfolios.size() == 1 ? this.portfolios.get(0) : PortfolioSnapshot.merge(this.portfolios, this.converter);
            }
        }
        return this.jointPortfolio;
    }

    public Money getMonetaryAssets() {
        if (this.assets == null) {
            MutableMoney sum = MutableMoney.of(this.getCurrencyCode());
            for (AccountSnapshot account : this.accounts) {
                sum.add(account.getFunds());
            }
            sum.add(this.getJointPortfolio().getValue());
            this.assets = sum.toMoney();
        }
        return this.assets;
    }

    public GroupByTaxonomy groupByTaxonomy(Taxonomy taxonomy) {
        return new GroupByTaxonomy(taxonomy, this);
    }

    public Map<InvestmentVehicle, AssetPosition> getPositionsByVehicle() {
        return this.getAssetPositions().collect(Collectors.toMap(p -> {
            InvestmentVehicle v = p.getInvestmentVehicle();
            if (v instanceof ReadOnlyAccount) {
                return ((ReadOnlyAccount)v).unwrap();
            }
            return v;
        }, v -> v));
    }

    public Stream<AssetPosition> getAssetPositions() {
        ArrayList<AssetPosition> answer = new ArrayList<AssetPosition>();
        Money monetaryAssets = this.getMonetaryAssets();
        for (SecurityPosition p : this.getJointPortfolio().getPositions()) {
            answer.add(new AssetPosition(p, this.converter, this.date, monetaryAssets));
        }
        for (AccountSnapshot a : this.accounts) {
            answer.add(new AssetPosition(new SecurityPosition(a), this.converter, this.date, monetaryAssets));
        }
        return answer.stream();
    }
}

