/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.filter.ClientFilterHelper;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyAccount;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyClient;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyPortfolio;

public class PortfolioClientFilter
implements ClientFilter {
    private final List<Portfolio> portfolios;
    private final List<Account> accounts;

    public PortfolioClientFilter(List<Portfolio> portfolios, List<Account> accounts) {
        this.portfolios = Objects.requireNonNull(portfolios);
        this.accounts = Objects.requireNonNull(accounts);
    }

    public PortfolioClientFilter(Portfolio portfolio) {
        this(Arrays.asList(portfolio), Collections.emptyList());
    }

    public PortfolioClientFilter(Portfolio portfolio, Account account) {
        this(Arrays.asList(portfolio), Arrays.asList(account));
    }

    @Override
    public Client filter(Client client) {
        ReadOnlyClient pseudoClient = new ReadOnlyClient(client);
        HashMap<Account, ReadOnlyAccount> account2pseudo = new HashMap<Account, ReadOnlyAccount>();
        Function<Account, ReadOnlyAccount> computeReadOnlyAccount = a -> {
            ReadOnlyAccount pa = new ReadOnlyAccount((Account)a);
            pseudoClient.internalAddAccount(pa);
            return pa;
        };
        this.accounts.stream().forEach(a -> {
            ReadOnlyAccount readOnlyAccount = account2pseudo.put((Account)a, (ReadOnlyAccount)computeReadOnlyAccount.apply((Account)a));
        });
        HashMap<Portfolio, ReadOnlyPortfolio> portfolio2pseudo = new HashMap<Portfolio, ReadOnlyPortfolio>();
        this.portfolios.stream().forEach(p -> {
            ReadOnlyAccount pseudoAccount = (ReadOnlyAccount)account2pseudo.computeIfAbsent(p.getReferenceAccount(), computeReadOnlyAccount);
            ReadOnlyPortfolio pseudoPortfolio = new ReadOnlyPortfolio((Portfolio)p);
            pseudoPortfolio.setReferenceAccount(pseudoAccount);
            pseudoClient.internalAddPortfolio(pseudoPortfolio);
            portfolio2pseudo.put((Portfolio)p, pseudoPortfolio);
        });
        HashSet<Security> usedSecurities = new HashSet<Security>();
        HashSet<AccountTransaction> processedSecurityTx = new HashSet<AccountTransaction>();
        for (Portfolio portfolio : this.portfolios) {
            this.adaptPortfolioTransactions(portfolio, portfolio2pseudo, account2pseudo, usedSecurities);
            if (this.accounts.contains(portfolio.getReferenceAccount())) continue;
            this.collectSecurityRelevantTx(portfolio, (ReadOnlyAccount)account2pseudo.get(portfolio.getReferenceAccount()), usedSecurities, processedSecurityTx);
        }
        for (Account account : this.accounts) {
            this.adaptAccountTransactions(account, account2pseudo, usedSecurities);
        }
        for (Security security : usedSecurities) {
            pseudoClient.internalAddSecurity(security);
        }
        return pseudoClient;
    }

    private void adaptPortfolioTransactions(Portfolio portfolio, Map<Portfolio, ReadOnlyPortfolio> portfolio2pseudo, Map<Account, ReadOnlyAccount> account2pseudo, Set<Security> usedSecurities) {
        ReadOnlyPortfolio pseudoPortfolio = portfolio2pseudo.get(portfolio);
        block7: for (PortfolioTransaction t : portfolio.getTransactions()) {
            usedSecurities.add(t.getSecurity());
            switch (t.getType()) {
                case BUY: {
                    if (this.accounts.contains(t.getCrossEntry().getCrossOwner(t))) {
                        this.recreateBuySell((BuySellEntry)t.getCrossEntry(), pseudoPortfolio, account2pseudo.get(t.getCrossEntry().getCrossOwner(t)));
                        break;
                    }
                    pseudoPortfolio.internalAddTransaction(this.convertTo(t, PortfolioTransaction.Type.DELIVERY_INBOUND));
                    break;
                }
                case TRANSFER_IN: {
                    if (this.portfolios.contains(t.getCrossEntry().getCrossOwner(t))) {
                        ClientFilterHelper.recreateTransfer((PortfolioTransferEntry)t.getCrossEntry(), portfolio2pseudo.get(t.getCrossEntry().getCrossOwner(t)), pseudoPortfolio);
                        break;
                    }
                    pseudoPortfolio.internalAddTransaction(this.convertTo(t, PortfolioTransaction.Type.DELIVERY_INBOUND));
                    break;
                }
                case SELL: {
                    if (this.accounts.contains(t.getCrossEntry().getCrossOwner(t))) {
                        this.recreateBuySell((BuySellEntry)t.getCrossEntry(), pseudoPortfolio, account2pseudo.get(t.getCrossEntry().getCrossOwner(t)));
                        break;
                    }
                    pseudoPortfolio.internalAddTransaction(this.convertTo(t, PortfolioTransaction.Type.DELIVERY_OUTBOUND));
                    break;
                }
                case TRANSFER_OUT: {
                    if (this.portfolios.contains(t.getCrossEntry().getCrossOwner(t))) continue block7;
                    pseudoPortfolio.internalAddTransaction(this.convertTo(t, PortfolioTransaction.Type.DELIVERY_OUTBOUND));
                    break;
                }
                case DELIVERY_INBOUND: 
                case DELIVERY_OUTBOUND: {
                    pseudoPortfolio.internalAddTransaction(t);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private void recreateBuySell(BuySellEntry buySell, ReadOnlyPortfolio readOnlyPortfolio, ReadOnlyAccount readOnlyAccount) {
        PortfolioTransaction t = buySell.getPortfolioTransaction();
        BuySellEntry copy = new BuySellEntry(readOnlyPortfolio, readOnlyAccount);
        copy.setDate(t.getDateTime());
        copy.setCurrencyCode(t.getCurrencyCode());
        copy.setSecurity(t.getSecurity());
        copy.setType(t.getType());
        copy.setNote(t.getNote());
        copy.setShares(t.getShares());
        copy.setAmount(t.getAmount());
        t.getUnits().forEach(u -> copy.getPortfolioTransaction().addUnit((Transaction.Unit)u));
        readOnlyPortfolio.internalAddTransaction(copy.getPortfolioTransaction());
        readOnlyAccount.internalAddTransaction(copy.getAccountTransaction());
    }

    private void collectSecurityRelevantTx(Portfolio portfolio, ReadOnlyAccount pseudoAccount, Set<Security> usedSecurities, Set<AccountTransaction> processedDividendTx) {
        if (portfolio.getReferenceAccount() == null) {
            return;
        }
        block5: for (AccountTransaction t : portfolio.getReferenceAccount().getTransactions()) {
            if (t.getSecurity() == null || !usedSecurities.contains(t.getSecurity())) continue;
            switch (t.getType()) {
                case DIVIDENDS: 
                case FEES_REFUND: 
                case TAX_REFUND: {
                    if (processedDividendTx.contains(t)) continue block5;
                    pseudoAccount.internalAddTransaction(t);
                    pseudoAccount.internalAddTransaction(new AccountTransaction(t.getDateTime(), t.getCurrencyCode(), t.getAmount(), null, AccountTransaction.Type.REMOVAL));
                    processedDividendTx.add(t);
                    break;
                }
                case FEES: 
                case TAXES: {
                    if (processedDividendTx.contains(t)) continue block5;
                    pseudoAccount.internalAddTransaction(t);
                    pseudoAccount.internalAddTransaction(new AccountTransaction(t.getDateTime(), t.getCurrencyCode(), t.getAmount(), null, AccountTransaction.Type.DEPOSIT));
                    processedDividendTx.add(t);
                    break;
                }
                case DEPOSIT: 
                case REMOVAL: 
                case INTEREST: 
                case INTEREST_CHARGE: 
                case BUY: 
                case SELL: 
                case TRANSFER_IN: 
                case TRANSFER_OUT: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private void adaptAccountTransactions(Account account, Map<Account, ReadOnlyAccount> account2pseudo, Set<Security> usedSecurities) {
        ReadOnlyAccount pseudoAccount = account2pseudo.get(account);
        block9: for (AccountTransaction t : account.getTransactions()) {
            switch (t.getType()) {
                case BUY: {
                    if (this.portfolios.contains(t.getCrossEntry().getCrossOwner(t))) continue block9;
                    pseudoAccount.internalAddTransaction(this.convertTo(t, AccountTransaction.Type.REMOVAL));
                    break;
                }
                case SELL: {
                    if (this.portfolios.contains(t.getCrossEntry().getCrossOwner(t))) continue block9;
                    pseudoAccount.internalAddTransaction(this.convertTo(t, AccountTransaction.Type.DEPOSIT));
                    break;
                }
                case TRANSFER_IN: {
                    if (this.accounts.contains(t.getCrossEntry().getCrossOwner(t))) {
                        ClientFilterHelper.recreateTransfer((AccountTransferEntry)t.getCrossEntry(), account2pseudo.get(t.getCrossEntry().getCrossOwner(t)), pseudoAccount);
                        break;
                    }
                    pseudoAccount.internalAddTransaction(this.convertTo(t, AccountTransaction.Type.DEPOSIT));
                    break;
                }
                case TRANSFER_OUT: {
                    if (this.accounts.contains(t.getCrossEntry().getCrossOwner(t))) continue block9;
                    pseudoAccount.internalAddTransaction(this.convertTo(t, AccountTransaction.Type.REMOVAL));
                    break;
                }
                case DIVIDENDS: 
                case FEES_REFUND: 
                case TAX_REFUND: {
                    if (t.getSecurity() == null || usedSecurities.contains(t.getSecurity())) {
                        pseudoAccount.internalAddTransaction(t);
                        break;
                    }
                    pseudoAccount.internalAddTransaction(this.convertTo(t, AccountTransaction.Type.DEPOSIT));
                    break;
                }
                case FEES: 
                case TAXES: {
                    if (t.getSecurity() == null || usedSecurities.contains(t.getSecurity())) {
                        pseudoAccount.internalAddTransaction(t);
                        break;
                    }
                    pseudoAccount.internalAddTransaction(this.convertTo(t, AccountTransaction.Type.REMOVAL));
                    break;
                }
                case DEPOSIT: 
                case REMOVAL: 
                case INTEREST: 
                case INTEREST_CHARGE: {
                    pseudoAccount.internalAddTransaction(t);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private PortfolioTransaction convertTo(PortfolioTransaction t, PortfolioTransaction.Type type) {
        PortfolioTransaction clone = new PortfolioTransaction();
        clone.setType(type);
        clone.setDateTime(t.getDateTime());
        clone.setCurrencyCode(t.getCurrencyCode());
        clone.setSecurity(t.getSecurity());
        clone.setAmount(t.getAmount());
        clone.setShares(t.getShares());
        clone.addUnits(t.getUnits());
        return clone;
    }

    private AccountTransaction convertTo(AccountTransaction t, AccountTransaction.Type type) {
        AccountTransaction clone = new AccountTransaction();
        clone.setType(type);
        clone.setDateTime(t.getDateTime());
        clone.setCurrencyCode(t.getCurrencyCode());
        clone.setSecurity(null);
        clone.setAmount(t.getAmount());
        clone.setShares(t.getShares());
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accounts == null ? 0 : this.accounts.hashCode());
        result = 31 * result + (this.portfolios == null ? 0 : this.portfolios.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortfolioClientFilter other = (PortfolioClientFilter)obj;
        return this.accounts.equals(other.accounts) && this.portfolios.equals(other.portfolios);
    }
}

