/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.util.Comparator;
import java.util.Optional;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;

final class CalculationLineItemComparator
implements Comparator<CalculationLineItem> {
    CalculationLineItemComparator() {
    }

    @Override
    public int compare(CalculationLineItem t1, CalculationLineItem t2) {
        boolean second;
        int compare = this.typeOrder(t1) - this.typeOrder(t2);
        if (compare != 0) {
            return compare;
        }
        compare = t1.getDateTime().compareTo(t2.getDateTime());
        if (compare != 0) {
            return compare;
        }
        boolean first = this.isInbound(t1);
        if (first ^ (second = this.isInbound(t2))) {
            return first ? -1 : 1;
        }
        return 0;
    }

    private int typeOrder(CalculationLineItem t1) {
        if (t1 instanceof CalculationLineItem.ValuationAtStart) {
            return -1;
        }
        if (t1 instanceof CalculationLineItem.ValuationAtEnd) {
            return 1;
        }
        return 0;
    }

    private boolean isInbound(CalculationLineItem data) {
        if (data instanceof CalculationLineItem.ValuationAtStart) {
            return true;
        }
        Optional<Transaction> transaction = data.getTransaction();
        if (transaction.isPresent() && transaction.get() instanceof PortfolioTransaction) {
            return ((PortfolioTransaction)transaction.get()).getType().isPurchase();
        }
        return false;
    }
}

