/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceRecord;
import name.abuchen.portfolio.util.Dates;

class DividendCalculation
extends Calculation {
    private final List<Payment> payments = new ArrayList<Payment>();
    private SecurityPerformanceRecord.Periodicity periodicity;
    private MutableMoney sum;
    private double rateOfReturnPerYear;

    DividendCalculation() {
    }

    @Override
    public void finish(CurrencyConverter converter, List<CalculationLineItem> lineItems) {
        int days;
        long daysBetweenPayments;
        if (this.payments.isEmpty()) {
            this.periodicity = SecurityPerformanceRecord.Periodicity.NONE;
            return;
        }
        this.periodicity = SecurityPerformanceRecord.Periodicity.UNKNOWN;
        Collections.sort(this.payments, (r, l) -> r.date.compareTo(l.date));
        LocalDate firstPayment = this.payments.get((int)0).date;
        LocalDate lastPayment = this.payments.get((int)(this.payments.size() - 1)).date;
        int significantCount = 0;
        int insignificantYears = 0;
        double sumRateOfReturn = 0.0;
        for (Payment p : this.payments) {
            this.sum.add(p.amount);
            sumRateOfReturn += p.rateOfReturn;
        }
        int years = 0;
        int year = firstPayment.getYear();
        while (year <= lastPayment.getYear()) {
            ++years;
            int countPerYear = 0;
            long sumPerYear = 0L;
            LocalDate lastDate = null;
            for (Payment p : this.payments) {
                if (p.year != year) continue;
                ++countPerYear;
                sumPerYear += p.amount.getAmount();
            }
            if (countPerYear == 0) {
                ++insignificantYears;
            } else {
                double expectedAmount = (double)sumPerYear / (double)countPerYear;
                for (Payment p : this.payments) {
                    if (p.year != year) continue;
                    double significance = (double)p.amount.getAmount() / expectedAmount;
                    if (significance > 0.3 && (lastDate == null || !p.date.equals(lastDate))) {
                        ++significantCount;
                    }
                    lastDate = p.date;
                }
            }
            ++year;
        }
        this.rateOfReturnPerYear = sumRateOfReturn / (double)years;
        if (significantCount > 0 && (daysBetweenPayments = Math.round((double)(days = Dates.daysBetween(firstPayment, lastPayment) - insignificantYears * 365) / (double)(significantCount - 1))) < 430L) {
            if (daysBetweenPayments > 270L) {
                this.periodicity = SecurityPerformanceRecord.Periodicity.ANNUAL;
            } else if (daysBetweenPayments > 130L) {
                this.periodicity = SecurityPerformanceRecord.Periodicity.SEMIANNUAL;
            } else if (daysBetweenPayments > 60L) {
                this.periodicity = SecurityPerformanceRecord.Periodicity.QUARTERLY;
            } else if (daysBetweenPayments > 20L) {
                this.periodicity = SecurityPerformanceRecord.Periodicity.MONTHLY;
            }
        }
    }

    public LocalDate getLastDividendPayment() {
        return this.payments.isEmpty() ? null : this.payments.get((int)(this.payments.size() - 1)).date;
    }

    public int getNumOfEvents() {
        return this.payments.size();
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public SecurityPerformanceRecord.Periodicity getPeriodicity() {
        return this.periodicity;
    }

    public double getRateOfReturnPerYear() {
        return this.rateOfReturnPerYear;
    }

    public Money getSum() {
        return this.sum.toMoney();
    }

    @Override
    public void setTermCurrency(String termCurrency) {
        super.setTermCurrency(termCurrency);
        this.sum = MutableMoney.of(termCurrency);
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.DividendPayment t) {
        this.payments.add(new Payment(converter, t, this.getSecurity()));
    }

    private static class Payment {
        public final Money amount;
        public final LocalDate date;
        public final int year;
        public final double rateOfReturn;

        public Payment(CurrencyConverter converter, CalculationLineItem.DividendPayment t, Security security) {
            this.amount = t.getGrossValue().with(converter.at(t.getDateTime()));
            LocalDateTime time = t.getDateTime();
            this.year = time.getYear();
            this.date = time.toLocalDate();
            double rr = Double.NaN;
            if (security != null) {
                SecurityPrice p;
                long pValue;
                Money movingAverageCost = t.getMovingAverageCost();
                if (movingAverageCost != null && !movingAverageCost.isZero()) {
                    rr = (double)t.getGrossValueAmount() / (double)movingAverageCost.getAmount();
                }
                if (rr == 0.0 && (pValue = (p = security.getSecurityPrice(this.date)).getValue()) != 0L) {
                    double sharePriceAmount = (double)pValue / (double)Values.Quote.factor() * (double)Values.AmountFraction.factor();
                    rr = (double)t.getDividendPerShare() / sharePriceAmount;
                }
            }
            this.rateOfReturn = rr;
        }
    }
}

