/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.math.IRR;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;

class IRRCalculation
extends Calculation {
    private List<LocalDate> dates = new ArrayList<LocalDate>();
    private List<Double> values = new ArrayList<Double>();

    IRRCalculation() {
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtStart t) {
        this.dates.add(t.getDateTime().toLocalDate());
        this.values.add((double)(-t.getValue().with(converter.at(t.getDateTime())).getAmount()) / Values.Amount.divider());
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtEnd t) {
        this.dates.add(t.getDateTime().toLocalDate());
        this.values.add((double)t.getValue().with(converter.at(t.getDateTime())).getAmount() / Values.Amount.divider());
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.DividendPayment t) {
        this.dates.add(t.getDateTime().toLocalDate());
        long taxes = t.getTransaction().orElseThrow(IllegalArgumentException::new).getUnitSum(Transaction.Unit.Type.TAX, converter).getAmount();
        long amount = t.getValue().with(converter.at(t.getDateTime())).getAmount();
        this.values.add((double)(amount + taxes) / Values.Amount.divider());
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, AccountTransaction t) {
        switch (t.getType()) {
            case TAXES: 
            case TAX_REFUND: {
                break;
            }
            case FEES: {
                this.dates.add(t.getDateTime().toLocalDate());
                this.values.add((double)(-converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount()) / Values.Amount.divider());
                break;
            }
            case FEES_REFUND: {
                this.dates.add(t.getDateTime().toLocalDate());
                this.values.add((double)converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount() / Values.Amount.divider());
            }
        }
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, PortfolioTransaction t) {
        this.dates.add(t.getDateTime().toLocalDate());
        long taxes = t.getUnitSum(Transaction.Unit.Type.TAX, converter).getAmount();
        long amount = t.getMonetaryAmount(converter).getAmount();
        switch (t.getType()) {
            case BUY: 
            case TRANSFER_IN: 
            case DELIVERY_INBOUND: {
                this.values.add((double)(-amount + taxes) / Values.Amount.divider());
                break;
            }
            case SELL: 
            case TRANSFER_OUT: 
            case DELIVERY_OUTBOUND: {
                this.values.add((double)(amount + taxes) / Values.Amount.divider());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public double getIRR() {
        if (this.dates.isEmpty()) {
            return Double.NaN;
        }
        return IRR.calculate(this.dates, this.values);
    }
}

