/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import name.abuchen.portfolio.math.Risk;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;
import name.abuchen.portfolio.snapshot.security.CalculationLineItemComparator;
import name.abuchen.portfolio.snapshot.security.CapitalGainsCalculation;
import name.abuchen.portfolio.snapshot.security.CapitalGainsRecord;
import name.abuchen.portfolio.snapshot.security.CostCalculation;
import name.abuchen.portfolio.snapshot.security.DeltaCalculation;
import name.abuchen.portfolio.snapshot.security.DividendCalculation;
import name.abuchen.portfolio.snapshot.security.IRRCalculation;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceIndicator;
import name.abuchen.portfolio.snapshot.security.SharesHeldCalculation;
import name.abuchen.portfolio.snapshot.trail.Trail;
import name.abuchen.portfolio.snapshot.trail.TrailProvider;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;
import name.abuchen.portfolio.util.Interval;

public final class SecurityPerformanceRecord
implements Adaptable,
TrailProvider,
SecurityPerformanceIndicator.Costs {
    private final Security security;
    private final List<CalculationLineItem> lineItems;
    private double irr;
    private double twror;
    private Risk.Drawdown drawdown;
    private Risk.Volatility volatility;
    private Money delta;
    private double deltaPercent;
    private Money marketValue;
    private SecurityPrice quote;
    private Money fifoCost;
    private TrailRecord fifoCostTrail;
    private Money movingAverageCost;
    private Money fees;
    private Money taxes;
    private long sharesHeld;
    private Quote fifoCostPerSharesHeld;
    private Quote movingAverageCostPerSharesHeld;
    private Money sumOfDividends;
    private int dividendEventCount;
    private LocalDate lastDividendPayment;
    private Periodicity periodicity = Periodicity.UNKNOWN;
    private double rateOfReturnPerYear;
    private Money capitalGainsOnHoldings;
    private double capitalGainsOnHoldingsPercent;
    private Money capitalGainsOnHoldingsMovingAverage;
    private double capitalGainsOnHoldingsMovingAveragePercent;
    private CapitalGainsRecord realizedCapitalGains;
    private CapitalGainsRecord unrealizedCapitalGains;

    private SecurityPerformanceRecord(Security security, List<CalculationLineItem> lineItems) {
        this.security = security;
        this.lineItems = lineItems;
    }

    public Security getSecurity() {
        return this.security;
    }

    public String getSecurityName() {
        return this.getSecurity().getName();
    }

    public String getNote() {
        return this.getSecurity().getNote();
    }

    public double getIrr() {
        return this.irr;
    }

    public double getTrueTimeWeightedRateOfReturn() {
        return this.twror;
    }

    public double getMaxDrawdown() {
        return this.drawdown.getMaxDrawdown();
    }

    public long getMaxDrawdownDuration() {
        return this.drawdown.getMaxDrawdownDuration().getDays();
    }

    public double getVolatility() {
        return this.volatility.getStandardDeviation();
    }

    public double getSemiVolatility() {
        return this.volatility.getSemiDeviation();
    }

    public Money getDelta() {
        return this.delta;
    }

    public double getDeltaPercent() {
        return this.deltaPercent;
    }

    public Money getMarketValue() {
        return this.marketValue;
    }

    public Quote getQuote() {
        return Quote.of(this.security.getCurrencyCode(), this.quote.getValue());
    }

    public SecurityPrice getLatestSecurityPrice() {
        return this.quote;
    }

    @Override
    public Money getFifoCost() {
        return this.fifoCost;
    }

    @Override
    public Money getMovingAverageCost() {
        return this.movingAverageCost;
    }

    public Money getCapitalGainsOnHoldings() {
        return this.capitalGainsOnHoldings;
    }

    public double getCapitalGainsOnHoldingsPercent() {
        return this.capitalGainsOnHoldingsPercent;
    }

    public Money getCapitalGainsOnHoldingsMovingAverage() {
        return this.capitalGainsOnHoldingsMovingAverage;
    }

    public double getCapitalGainsOnHoldingsMovingAveragePercent() {
        return this.capitalGainsOnHoldingsMovingAveragePercent;
    }

    public Money getFees() {
        return this.fees;
    }

    public Money getTaxes() {
        return this.taxes;
    }

    public long getSharesHeld() {
        return this.sharesHeld;
    }

    @Override
    public Quote getFifoCostPerSharesHeld() {
        return this.fifoCostPerSharesHeld;
    }

    @Override
    public Quote getMovingAverageCostPerSharesHeld() {
        return this.movingAverageCostPerSharesHeld;
    }

    public Money getSumOfDividends() {
        return this.sumOfDividends;
    }

    public int getDividendEventCount() {
        return this.dividendEventCount;
    }

    public LocalDate getLastDividendPayment() {
        return this.lastDividendPayment;
    }

    public Periodicity getPeriodicity() {
        return this.periodicity;
    }

    public int getPeriodicitySort() {
        return this.periodicity.ordinal();
    }

    public double getRateOfReturnPerYear() {
        return this.rateOfReturnPerYear;
    }

    public double getTotalRateOfReturnDiv() {
        return this.sharesHeld > 0L ? (double)this.sumOfDividends.getAmount() / (double)this.fifoCost.getAmount() : 0.0;
    }

    public double getTotalRateOfReturnDivMovingAverage() {
        return this.sharesHeld > 0L ? (double)this.sumOfDividends.getAmount() / (double)this.movingAverageCost.getAmount() : 0.0;
    }

    public CapitalGainsRecord getRealizedCapitalGains() {
        return this.realizedCapitalGains;
    }

    public CapitalGainsRecord getUnrealizedCapitalGains() {
        return this.unrealizedCapitalGains;
    }

    public List<CalculationLineItem> getLineItems() {
        return this.lineItems;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        if (type == Security.class) {
            return type.cast(this.security);
        }
        if (type == Attributable.class) {
            return type.cast(this.security);
        }
        if (type == Named.class) {
            return type.cast(this.security);
        }
        if (type == InvestmentVehicle.class) {
            return type.cast(this.security);
        }
        if (type == Annotated.class) {
            return type.cast(this.security);
        }
        return null;
    }

    @Override
    public Optional<Trail> explain(String key) {
        switch (key) {
            case "fifoCost": {
                return Trail.of(this.getSecurityName(), this.fifoCostTrail);
            }
            case "realizedCapitalGains": {
                return Trail.of(this.getSecurityName(), this.getRealizedCapitalGains().getCapitalGainsTrail());
            }
            case "realizedCapitalGainsForex": {
                return Trail.of(this.getSecurityName(), this.getRealizedCapitalGains().getForexCapitalGainsTrail());
            }
            case "unrealizedCapitalGains": {
                return Trail.of(this.getSecurityName(), this.getUnrealizedCapitalGains().getCapitalGainsTrail());
            }
            case "unrealizedCapitalGainsForex": {
                return Trail.of(this.getSecurityName(), this.getUnrealizedCapitalGains().getForexCapitalGainsTrail());
            }
        }
        return Optional.empty();
    }

    @SafeVarargs
    final void calculate(Client client, CurrencyConverter converter, Interval interval, Class<? extends SecurityPerformanceIndicator> ... indicators) {
        Collections.sort(this.lineItems, new CalculationLineItemComparator());
        HashSet flags = new HashSet();
        Arrays.stream(indicators).forEach(flags::add);
        if (!this.lineItems.isEmpty()) {
            if (flags.isEmpty() || flags.contains(SecurityPerformanceIndicator.Costs.class)) {
                this.calculateSharesHeld(converter);
                this.calculateMarketValue(converter, interval);
            }
            if (flags.isEmpty()) {
                this.calculateIRR(converter);
                this.calculateTTWROR(client, converter, interval);
                this.calculateDelta(converter);
            }
            if (flags.isEmpty() || flags.contains(SecurityPerformanceIndicator.Costs.class)) {
                this.calculateFifoAndMovingAverageCosts(converter);
            }
            if (flags.isEmpty()) {
                this.calculateDividends(converter);
                this.calculatePeriodicity(client, converter);
            }
            if (flags.isEmpty() || flags.contains(SecurityPerformanceIndicator.CapitalGains.class)) {
                this.calculateCapitalGains(converter);
            }
        }
    }

    private void calculateSharesHeld(CurrencyConverter converter) {
        this.sharesHeld = Calculation.perform(SharesHeldCalculation.class, converter, this.security, this.lineItems).getSharesHeld();
    }

    private void calculateMarketValue(CurrencyConverter converter, Interval interval) {
        this.marketValue = this.lineItems.stream().filter(data -> data instanceof CalculationLineItem.ValuationAtEnd).map(CalculationLineItem::getValue).collect(MoneyCollectors.sum(this.security.getCurrencyCode())).with(converter.at(interval.getEnd()));
        this.quote = this.security.getSecurityPrice(interval.getEnd());
    }

    private void calculateIRR(CurrencyConverter converter) {
        this.irr = Calculation.perform(IRRCalculation.class, converter, this.security, this.lineItems).getIRR();
    }

    private void calculateTTWROR(Client client, CurrencyConverter converter, Interval interval) {
        PerformanceIndex index = PerformanceIndex.forInvestment(client, converter, this.security, interval, new ArrayList<Exception>());
        this.twror = index.getFinalAccumulatedPercentage();
        this.drawdown = index.getDrawdown();
        this.volatility = index.getVolatility();
    }

    private void calculateDelta(CurrencyConverter converter) {
        DeltaCalculation calculation = Calculation.perform(DeltaCalculation.class, converter, this.security, this.lineItems);
        this.delta = calculation.getDelta();
        this.deltaPercent = calculation.getDeltaPercent();
    }

    private void calculateFifoAndMovingAverageCosts(CurrencyConverter converter) {
        CostCalculation cost = Calculation.perform(CostCalculation.class, converter, this.security, this.lineItems);
        this.fifoCost = cost.getFifoCost();
        this.fifoCostTrail = cost.getFifoCostTrail();
        this.movingAverageCost = cost.getMovingAverageCost();
        Money netFifoCost = cost.getNetFifoCost();
        this.fifoCostPerSharesHeld = Quote.of(netFifoCost.getCurrencyCode(), Math.round((double)netFifoCost.getAmount() / (double)this.sharesHeld * (double)Values.Share.factor() * (double)Values.Quote.factorToMoney()));
        Money netMovingAverageCost = cost.getNetMovingAverageCost();
        this.movingAverageCostPerSharesHeld = Quote.of(netMovingAverageCost.getCurrencyCode(), Math.round((double)netMovingAverageCost.getAmount() / (double)this.sharesHeld * (double)Values.Share.factor() * (double)Values.Quote.factorToMoney()));
        this.fees = cost.getFees();
        this.taxes = cost.getTaxes();
        this.capitalGainsOnHoldings = this.marketValue.subtract(this.fifoCost);
        this.capitalGainsOnHoldingsMovingAverage = this.marketValue.subtract(this.movingAverageCost);
        this.capitalGainsOnHoldingsPercent = this.marketValue.getAmount() == 0L && this.fifoCost.getAmount() == 0L ? 0.0 : (double)this.marketValue.getAmount() / (double)this.fifoCost.getAmount() - 1.0;
        this.capitalGainsOnHoldingsMovingAveragePercent = this.marketValue.getAmount() == 0L && this.movingAverageCost.getAmount() == 0L ? 0.0 : (double)this.marketValue.getAmount() / (double)this.movingAverageCost.getAmount() - 1.0;
    }

    private void calculateDividends(CurrencyConverter converter) {
        DividendCalculation dividends = Calculation.perform(DividendCalculation.class, converter, this.security, this.lineItems);
        this.sumOfDividends = dividends.getSum();
        this.dividendEventCount = dividends.getNumOfEvents();
        this.lastDividendPayment = dividends.getLastDividendPayment();
        this.rateOfReturnPerYear = dividends.getRateOfReturnPerYear();
    }

    private void calculatePeriodicity(Client client, CurrencyConverter converter) {
        List<CalculationLineItem> allDividendPayments = this.security.getTransactions(client).stream().filter(t -> t.getTransaction() instanceof AccountTransaction).filter(t -> {
            AccountTransaction.Type type = ((AccountTransaction)t.getTransaction()).getType();
            return type == AccountTransaction.Type.DIVIDENDS;
        }).map(CalculationLineItem::of).collect(Collectors.toList());
        DividendCalculation allDividends = Calculation.perform(DividendCalculation.class, converter, this.security, allDividendPayments);
        this.periodicity = allDividends.getPeriodicity();
    }

    private void calculateCapitalGains(CurrencyConverter converter) {
        CapitalGainsCalculation calculation = Calculation.perform(CapitalGainsCalculation.class, converter, this.security, this.lineItems);
        this.realizedCapitalGains = calculation.getRealizedCapitalGains();
        this.unrealizedCapitalGains = calculation.getUnrealizedCapitalGains();
    }

    /* synthetic */ SecurityPerformanceRecord(Security security, List list, SecurityPerformanceRecord securityPerformanceRecord) {
        this(security, list);
    }

    static final class Builder {
        private final Security security;
        private final List<CalculationLineItem> lineItems = new ArrayList<CalculationLineItem>();

        public Builder(Security security) {
            this.security = security;
        }

        public void addLineItem(CalculationLineItem item) {
            this.lineItems.add(item);
        }

        public boolean isEmpty() {
            return this.lineItems.isEmpty();
        }

        @SafeVarargs
        public final SecurityPerformanceRecord build(Client client, CurrencyConverter converter, Interval interval, Class<? extends SecurityPerformanceIndicator> ... indicators) {
            SecurityPerformanceRecord record = new SecurityPerformanceRecord(this.security, this.lineItems, null);
            record.calculate(client, converter, interval, indicators);
            return record;
        }
    }

    public static enum Periodicity {
        UNKNOWN,
        NONE,
        INDEFINITE,
        ANNUAL,
        SEMIANNUAL,
        QUARTERLY,
        MONTHLY,
        IRREGULAR;

        private static final ResourceBundle RESOURCES;

        static {
            RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.snapshot.labels");
        }

        public String toString() {
            return RESOURCES.getString("dividends." + this.name());
        }
    }

    public static interface Trails {
        public static final String FIFO_COST = "fifoCost";
        public static final String REALIZED_CAPITAL_GAINS = "realizedCapitalGains";
        public static final String REALIZED_CAPITAL_GAINS_FOREX = "realizedCapitalGainsForex";
        public static final String UNREALIZED_CAPITAL_GAINS = "unrealizedCapitalGains";
        public static final String UNREALIZED_CAPITAL_GAINS_FOREX = "unrealizedCapitalGainsForex";
    }
}

