/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

class ArithmeticTrail
implements TrailRecord {
    private final Operation operation;
    private final String label;
    private final Money value;
    private final List<TrailRecord> children = new ArrayList<TrailRecord>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArithmeticTrail(Operation operation, String label, TrailRecord ... inputs) {
        this.operation = operation;
        this.label = label;
        this.children.addAll(Arrays.asList(inputs));
        if (!this.children.isEmpty()) {
            if (operation == Operation.ADDITION) {
                this.value = this.children.stream().map(TrailRecord::getValue).filter(Objects::nonNull).collect(MoneyCollectors.sum(this.children.get(0).getValue().getCurrencyCode()));
                return;
            } else {
                if (operation != Operation.SUBTRACTION) throw new UnsupportedOperationException();
                MutableMoney subtraction = MutableMoney.of(this.children.get(0).getValue());
                int index = 1;
                while (index < inputs.length) {
                    subtraction.subtract(this.children.get(index).getValue());
                    ++index;
                }
                this.value = subtraction.toMoney();
            }
            return;
        } else {
            this.value = null;
        }
    }

    @Override
    public LocalDate getDate() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Long getShares() {
        return null;
    }

    @Override
    public Money getValue() {
        return this.value;
    }

    @Override
    public List<TrailRecord> getInputs() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public TrailRecord add(TrailRecord trail) {
        if (this.operation == Operation.ADDITION && trail instanceof ArithmeticTrail && ((ArithmeticTrail)trail).operation.equals((Object)this.operation)) {
            ArrayList<TrailRecord> trails = new ArrayList<TrailRecord>();
            trails.addAll(this.children);
            trails.addAll(((ArithmeticTrail)trail).children);
            return new ArithmeticTrail(this.operation, this.label, trails.toArray(new TrailRecord[0]));
        }
        if (this.operation == Operation.ADDITION) {
            ArrayList<TrailRecord> trails = new ArrayList<TrailRecord>();
            trails.addAll(this.children);
            trails.add(trail);
            return new ArithmeticTrail(this.operation, this.label, trails.toArray(new TrailRecord[0]));
        }
        return TrailRecord.super.add(trail);
    }

    @Override
    public TrailRecord subtract(TrailRecord trail) {
        if (this.operation == Operation.SUBTRACTION && trail instanceof ArithmeticTrail && ((ArithmeticTrail)trail).operation.equals((Object)this.operation)) {
            ArithmeticTrail answer = new ArithmeticTrail(this.operation, this.label, new TrailRecord[0]);
            answer.children.addAll(this.children);
            answer.children.add(trail);
            return answer;
        }
        return TrailRecord.super.subtract(trail);
    }

    public static enum Operation {
        ADDITION,
        SUBTRACTION;

    }
}

