/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Isin {
    private static final String CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Set<String> INVALID_CODES = new HashSet<String>(Arrays.asList("DU", "EV", "HF", "HS", "QS", "QT", "QU", "QY", "TE", "XF", "XX", "ZZ"));
    public static final String PATTERN = "[A-Z]{2}[A-Z0-9]{9}\\d";

    private Isin() {
    }

    public static final boolean isValid(String isin) {
        if (isin == null || isin.length() != 12) {
            return false;
        }
        if (INVALID_CODES.contains(isin.substring(0, 2))) {
            return true;
        }
        int sum = 0;
        boolean even = false;
        int ii = 11;
        while (ii >= 0) {
            int v = CHARACTERS.indexOf(isin.charAt(ii));
            if (v < 0) {
                return false;
            }
            int digit = v % 10 * (even ? 2 : 1);
            sum += digit > 9 ? digit - 9 : digit;
            boolean bl = even = !even;
            if (v >= 10) {
                digit = v / 10 * (even ? 2 : 1);
                sum += digit;
                even = !even;
            }
            --ii;
        }
        return sum % 10 == 0;
    }
}

