/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.util.OnlineHelper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class WebAccess {
    public static final RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(2000).setConnectionRequestTimeout(20000).setCookieSpec("standard").build();
    private final URIBuilder builder;
    private List<Header> headers = new ArrayList<Header>();
    private String userAgent = OnlineHelper.getUserAgent();

    public WebAccess(String host, String path) {
        this.builder = new URIBuilder();
        this.builder.setScheme("https");
        this.builder.setHost(Objects.requireNonNull(host).trim());
        this.builder.setPath(Objects.requireNonNull(path).trim());
    }

    public WebAccess(String url) throws URISyntaxException {
        this.builder = new URIBuilder(url);
    }

    public WebAccess withScheme(String scheme) {
        this.builder.setScheme(Objects.requireNonNull(scheme).trim());
        return this;
    }

    public WebAccess withPort(Integer port) {
        this.builder.setPort(port != null ? port : -1);
        return this;
    }

    public WebAccess withFragment(String fragment) {
        this.builder.setFragment(Objects.requireNonNull(fragment).trim());
        return this;
    }

    public WebAccess addParameter(String param, String value) {
        this.builder.addParameter(param, value);
        return this;
    }

    public WebAccess addHeader(String param, String value) {
        this.headers.add((Header)new BasicHeader(param, value));
        return this;
    }

    public WebAccess addUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String get() throws IOException {
        CloseableHttpResponse response = this.executeWith(HttpGet::new);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    public void post(String body) throws IOException {
        this.executeWith(uri -> {
            HttpPost request = new HttpPost(uri);
            StringEntity userEntity = new StringEntity(body);
            request.setEntity((HttpEntity)userEntity);
            return request;
        });
    }

    private CloseableHttpResponse executeWith(Request function) throws IOException {
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(defaultRequestConfig).setDefaultHeaders(this.headers).setUserAgent(this.userAgent).useSystemProperties().build();
            URI uri = this.builder.build();
            HttpRequestBase request = function.create(uri);
            response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new WebAccessException(String.valueOf(uri.toString()) + " --> " + response.getStatusLine().getStatusCode(), response.getStatusLine().getStatusCode());
            }
            return response;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public String getURL() throws URISyntaxException {
        return this.builder.build().toASCIIString();
    }

    @FunctionalInterface
    private static interface Request {
        public HttpRequestBase create(URI var1) throws IOException;
    }

    public static class WebAccessException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final int httpErrorCode;

        public WebAccessException(String message, int httpErrorCode) {
            super(message);
            this.httpErrorCode = httpErrorCode;
        }

        public int getHttpErrorCode() {
            return this.httpErrorCode;
        }
    }
}

