/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.bootstrap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import name.abuchen.portfolio.bootstrap.FilePickerDialog;
import name.abuchen.portfolio.bootstrap.Messages;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CustomSaveHandler
extends PartServiceSaveHandler {
    public ISaveHandler.Save promptToSave(MPart dirtyPart) {
        MApplication app;
        Object clientInput = dirtyPart.getTransientData().get("name.abuchen.portfolio.ui.editor.ClientInput");
        if (clientInput == null) {
            throw new IllegalArgumentException();
        }
        EModelService modelService = (EModelService)dirtyPart.getContext().get(EModelService.class);
        int count = modelService.findElements((MApplicationElement)(app = (MApplication)dirtyPart.getContext().get(MApplication.class)), MPart.class, 2, element -> {
            if (!"name.abuchen.portfolio.ui.part.portfolio".equals(element.getElementId())) {
                return false;
            }
            return clientInput.equals(element.getTransientData().get("name.abuchen.portfolio.ui.editor.ClientInput"));
        }).size();
        if (count > 1) {
            return ISaveHandler.Save.NO;
        }
        return this.promptToSaveSingle(dirtyPart);
    }

    public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
        Collection<FilePickerDialog.FileInfo> editorInputs = this.collectFileInfos(dirtyParts);
        if (editorInputs.size() == 1) {
            return new ISaveHandler.Save[]{this.promptToSaveSingle(editorInputs.iterator().next().getParts().get(0))};
        }
        return this.promptToSaveMultiple(dirtyParts, editorInputs);
    }

    private ISaveHandler.Save promptToSaveSingle(MPart dirtyPart) {
        String prompt = MessageFormat.format(Messages.SaveHandlerPrompt, dirtyPart.getLabel());
        PromptForSaveDialog dialog = new PromptForSaveDialog(Display.getDefault().getActiveShell(), prompt);
        switch (dialog.open()) {
            case 0: {
                return ISaveHandler.Save.YES;
            }
            case 1: {
                return ISaveHandler.Save.NO;
            }
        }
        return ISaveHandler.Save.CANCEL;
    }

    private ISaveHandler.Save[] promptToSaveMultiple(Collection<MPart> dirtyParts, Collection<FilePickerDialog.FileInfo> editorInputs) {
        FilePickerDialog dialog = new FilePickerDialog(Display.getDefault().getActiveShell());
        dialog.setElements(editorInputs);
        int returnCode = dialog.open();
        Object[] answer = new ISaveHandler.Save[dirtyParts.size()];
        Arrays.fill(answer, ISaveHandler.Save.NO);
        if (returnCode == 0) {
            if (dialog.getResult() != null) {
                ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object toBeSaved = objectArray[n2];
                    answer[parts.indexOf((Object)((FilePickerDialog.FileInfo)toBeSaved).getParts().get((int)0))] = ISaveHandler.Save.YES;
                    ++n2;
                }
            }
        } else if (returnCode == 42) {
            ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
            for (FilePickerDialog.FileInfo toBeSaved : editorInputs) {
                answer[parts.indexOf((Object)toBeSaved.getParts().get((int)0))] = ISaveHandler.Save.YES;
            }
        } else if (returnCode != 43 && returnCode == 1) {
            Arrays.fill(answer, ISaveHandler.Save.CANCEL);
        }
        return answer;
    }

    private Collection<FilePickerDialog.FileInfo> collectFileInfos(Collection<MPart> parts) {
        return parts.stream().filter(p -> "name.abuchen.portfolio.ui.part.portfolio".equals(p.getElementId())).collect(Collectors.toMap(p -> p.getTransientData().get("name.abuchen.portfolio.ui.editor.ClientInput"), p -> {
            FilePickerDialog.FileInfo info = new FilePickerDialog.FileInfo(p.getLabel(), p.getTooltip());
            info.addPart((MPart)p);
            return info;
        }, (r, l) -> {
            r.addParts(l.getParts());
            return r;
        })).values();
    }

    private static final class PromptForSaveDialog
    extends MessageDialog {
        private PromptForSaveDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, Messages.SaveHandlerTitle, null, dialogMessage, 2, new String[]{Messages.LabelYes, Messages.LabelNo, Messages.LabelCancel}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }
    }
}

