/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.bootstrap;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import name.abuchen.portfolio.bootstrap.LifeCycleManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MergeOldLayoutIntoCurrentApplicationModelProcessor {
    @Inject
    private EModelService modelService;
    @Inject
    private Logger logger;

    @Execute
    public void execute(MApplication theApp) {
        if (Boolean.parseBoolean(System.getProperty("model.forceClearPersistedState"))) {
            return;
        }
        if (!Boolean.parseBoolean(System.getProperty("clearPersistedState"))) {
            return;
        }
        File file = Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(LifeCycleManager.class)).append("copy.e4xmi").toFile();
        if (!file.exists()) {
            return;
        }
        this.logger.info(MessageFormat.format("Attempting to merge saved layout into current model from file {0}", file.getAbsolutePath()));
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        if (resource.getContents().isEmpty()) {
            return;
        }
        try {
            MApplication theAppCopy = (MApplication)resource.getContents().get(0);
            MWindow theWindow = (MWindow)theApp.getChildren().get(0);
            MWindow theWindowCopy = (MWindow)theAppCopy.getChildren().get(0);
            theWindow.setX(theWindowCopy.getX());
            theWindow.setY(theWindowCopy.getY());
            theWindow.setHeight(theWindowCopy.getHeight());
            theWindow.setWidth(theWindowCopy.getWidth());
            MUIElement theErrorLog = this.modelService.find("name.abuchen.portfolio.ui.part.errorlog", (MUIElement)theApp);
            MUIElement theErrorLogCopy = this.modelService.find("name.abuchen.portfolio.ui.part.errorlog", (MUIElement)theAppCopy);
            if (theErrorLog != null && theErrorLogCopy != null) {
                EcoreUtil.replace((EObject)((EObject)theErrorLogCopy), (EObject)((EObject)theErrorLog));
            } else if (theErrorLogCopy != null) {
                EcoreUtil.remove((EObject)((EObject)theErrorLogCopy));
            }
            theWindow.getChildren().clear();
            theWindow.getChildren().addAll(theWindowCopy.getChildren());
            List bindingContexts = this.modelService.findElements((MApplicationElement)theApp, MBindingContext.class, 29, element -> "name.abuchen.portfolio.file".equals(element.getElementId()));
            this.modelService.findElements((MApplicationElement)theApp, MPart.class, 2, element -> "name.abuchen.portfolio.ui.part.portfolio".equals(element.getElementId())).forEach(part -> {
                part.getBindingContexts().clear();
                part.getBindingContexts().addAll(bindingContexts);
            });
        }
        finally {
            resource.unload();
            resourceSet.getResources().remove((Object)resource);
        }
    }
}

