/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.addons;

import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.log.LogEntryCache;
import name.abuchen.portfolio.ui.update.UpdateHelper;
import name.abuchen.portfolio.ui.util.ProgressMonitorFactory;
import name.abuchen.portfolio.ui.util.RecentFilesCache;
import name.abuchen.portfolio.ui.util.swt.ActiveShell;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.event.Event;

public class StartupAddon {
    @PostConstruct
    public void setupProgressMontior(ProgressMonitorFactory factory) {
        IJobManager manager = Job.getJobManager();
        manager.setProgressProvider((ProgressProvider)factory);
    }

    @PostConstruct
    public void setupLogEntryCache(LogEntryCache cache) {
    }

    @PostConstruct
    public void setupRecentFilesCache(RecentFilesCache cache) {
    }

    @Inject
    @Optional
    public void checkForUpdates(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event, @Preference(value="AUTO_UPDATE") boolean autoUpdate) {
        if (autoUpdate) {
            Job job = new Job(Messages.JobMsgCheckingForUpdates){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(Messages.JobMsgCheckingForUpdates, 200);
                        UpdateHelper updateHelper = new UpdateHelper();
                        updateHelper.runUpdate(monitor, true);
                    }
                    catch (CoreException e) {
                        PortfolioPlugin.log(e.getStatus());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule(3000L);
        }
    }

    @PostConstruct
    public void updateExchangeRates(IEventBroker broker) {
        for (ExchangeRateProvider provider : ExchangeRateProviderFactory.getProviders()) {
            UpdateExchangeRatesJob job = new UpdateExchangeRatesJob(broker, provider);
            job.schedule();
        }
    }

    @PreDestroy
    public void storeExchangeRates() {
        for (ExchangeRateProvider provider : ExchangeRateProviderFactory.getProviders()) {
            try {
                provider.save((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
            }
        }
    }

    @PostConstruct
    public void setMultipleWindowImages() {
        if ("macosx".equals(Platform.getOS())) {
            return;
        }
        Window.setDefaultImages((Image[])new Image[]{Images.LOGO_512.image(), Images.LOGO_256.image(), Images.LOGO_128.image(), Images.LOGO_48.image(), Images.LOGO_32.image(), Images.LOGO_16.image()});
    }

    @PostConstruct
    public void replaceDefaultDialogImages() {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        registry.put("dialog_message_error_image", Images.ERROR.descriptor());
        registry.put("dialog_messasge_warning_image", Images.WARNING.descriptor());
        registry.put("dialog_messasge_info_image", Images.INFO.descriptor());
    }

    @PostConstruct
    public void setupActiveShellTracker() {
        ActiveShell.get();
    }

    private static final class UpdateExchangeRatesJob
    extends Job {
        private final IEventBroker broker;
        private final ExchangeRateProvider provider;
        private boolean loadDone = false;

        private UpdateExchangeRatesJob(IEventBroker broker, ExchangeRateProvider provider) {
            super(MessageFormat.format(Messages.MsgUpdatingExchangeRates, provider.getName()));
            this.broker = broker;
            this.provider = provider;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.loadDone) {
                this.loadFromFile(monitor);
                this.loadDone = true;
            }
            this.updateOnline(monitor);
            this.schedule(43200000L);
            return Status.OK_STATUS;
        }

        private void loadFromFile(IProgressMonitor monitor) {
            try {
                try {
                    this.provider.load(monitor);
                }
                catch (Exception e) {
                    PortfolioPlugin.log(e);
                    this.broker.post("exchangeRates/loaded", (Object)this.provider);
                }
            }
            finally {
                this.broker.post("exchangeRates/loaded", (Object)this.provider);
            }
        }

        private void updateOnline(IProgressMonitor monitor) {
            try {
                try {
                    this.provider.update(monitor);
                }
                catch (IOException e) {
                    PortfolioPlugin.log(e);
                    this.broker.post("exchangeRates/loaded", (Object)this.provider);
                }
            }
            finally {
                this.broker.post("exchangeRates/loaded", (Object)this.provider);
            }
        }
    }
}

