/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.AbstractDialog;
import name.abuchen.portfolio.ui.util.BindingHelper;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PasswordDialog
extends AbstractDialog {
    public PasswordDialog(Shell parentShell) {
        super(parentShell, Messages.TitlePasswordDialog, new PasswordModel());
    }

    @Override
    protected void createFormElements(Composite editArea) {
        final IObservableValue<String> password = this.bindings().bindStringInput(editArea, Messages.LabelPassword, "password", 0x400000);
        final IObservableValue<String> repeat = this.bindings().bindStringInput(editArea, Messages.LabelPasswordRepeat, "repeat", 0x400000);
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                String pwd = (String)password.getValue();
                String rpt = (String)repeat.getValue();
                if (pwd.length() < 6) {
                    return ValidationStatus.error((String)Messages.MsgPasswordMinCharacters);
                }
                return pwd.equals(rpt) ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.MsgPasswordNotIdentical);
            }
        };
        this.bindings().getBindingContext().addValidationStatusProvider((ValidationStatusProvider)validator);
    }

    public String getPassword() {
        return ((PasswordModel)this.getModel()).getPassword();
    }

    public static class PasswordModel
    extends BindingHelper.Model {
        private String password;
        private String repeat;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
            this.firePropertyChange("password", this.password, this.password);
        }

        public String getRepeat() {
            return this.repeat;
        }

        public void setRepeat(String repeat) {
            this.repeat = repeat;
            this.firePropertyChange("repeat", this.repeat, this.repeat);
        }

        @Override
        public void applyChanges() {
        }
    }
}

