/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.time.LocalDate;
import java.time.Period;
import java.util.Arrays;
import java.util.List;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.DatePicker;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ReportingPeriodDialog
extends Dialog {
    private final ReportingPeriod template;
    private ReportingPeriod result;
    private Button radioLast;
    private Spinner years;
    private Spinner months;
    private Button radioLastDays;
    private Spinner days;
    private Button radioLastTradingDays;
    private Spinner tradingDays;
    private Button radioFromXtoY;
    private DatePicker dateFrom;
    private DatePicker dateTo;
    private Button radioSinceX;
    private DatePicker dateSince;
    private Button radioYearX;
    private Spinner year;
    private Button radioCurrentMonth;
    private Button radioYTD;
    private List<Button> radioBtnList;

    public ReportingPeriodDialog(Shell parentShell, ReportingPeriod template) {
        super(parentShell);
        this.template = template != null ? template : new ReportingPeriod.LastX(1, 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LabelReportInterval);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite editArea = new Composite(composite, 0);
        editArea.setLayoutData((Object)new GridData(1808));
        editArea.setLayout((Layout)new FormLayout());
        this.radioLast = new Button(editArea, 16);
        this.radioLast.setText(Messages.LabelReportingDialogLast);
        this.years = new Spinner(editArea, 2048);
        this.years.setMinimum(0);
        Label lblYears = new Label(editArea, 0);
        lblYears.setText(Messages.LabelReportingDialogYears);
        this.months = new Spinner(editArea, 2048);
        this.months.setMinimum(0);
        this.months.setMaximum(11);
        Label lblMonths = new Label(editArea, 0);
        lblMonths.setText(Messages.LabelReportingDialogMonths);
        this.radioLastDays = new Button(editArea, 16);
        this.radioLastDays.setText(Messages.LabelReportingDialogLast);
        this.days = new Spinner(editArea, 2048);
        this.days.setMinimum(1);
        this.days.setMaximum(10000);
        Label lblDays = new Label(editArea, 0);
        lblDays.setText(Messages.LabelReportingDialogDays);
        this.radioLastTradingDays = new Button(editArea, 16);
        this.radioLastTradingDays.setText(Messages.LabelReportingDialogLast);
        this.tradingDays = new Spinner(editArea, 2048);
        this.tradingDays.setMinimum(1);
        this.tradingDays.setMaximum(10000);
        Label lblTradingDays = new Label(editArea, 0);
        lblTradingDays.setText(Messages.LabelReportingDialogTradingDays);
        this.radioFromXtoY = new Button(editArea, 16);
        this.radioFromXtoY.setText(Messages.LabelReportingDialogFrom);
        this.dateFrom = new DatePicker(editArea);
        Label lblTo = new Label(editArea, 0);
        lblTo.setText(Messages.LabelReportingDialogUntil);
        this.dateTo = new DatePicker(editArea);
        this.radioSinceX = new Button(editArea, 16);
        this.radioSinceX.setText(Messages.LabelReportingDialogSince);
        this.dateSince = new DatePicker(editArea);
        this.radioYearX = new Button(editArea, 16);
        this.radioYearX.setText(Messages.LabelReportingDialogYear);
        this.year = new Spinner(editArea, 2048);
        this.year.setMinimum(-999999999);
        this.year.setMaximum(999999999);
        this.radioCurrentMonth = new Button(editArea, 16);
        this.radioCurrentMonth.setText(Messages.LabelCurrentMonth);
        this.radioYTD = new Button(editArea, 16);
        this.radioYTD.setText(Messages.LabelYTD);
        FormDataFactory.startingWith((Control)this.radioLast).top(new FormAttachment(0, 10)).thenRight((Control)this.years).thenRight((Control)lblYears).thenRight((Control)this.months).thenRight((Control)lblMonths);
        FormDataFactory.startingWith((Control)this.radioLastDays).top(new FormAttachment((Control)this.radioLast, 20)).thenRight((Control)this.days).thenRight((Control)lblDays);
        FormDataFactory.startingWith((Control)this.radioLastTradingDays).top(new FormAttachment((Control)this.radioLastDays, 20)).thenRight((Control)this.tradingDays).thenRight((Control)lblTradingDays);
        if ("macosx".equals(Platform.getOS())) {
            FormDataFactory.startingWith((Control)this.radioFromXtoY).top(new FormAttachment((Control)this.radioLastTradingDays, 20)).thenRight(this.dateFrom.getControl()).top(new FormAttachment((Control)this.radioFromXtoY, -1, 128)).thenRight((Control)lblTo).top(new FormAttachment((Control)this.radioFromXtoY, 2, 128)).thenRight(this.dateTo.getControl()).top(new FormAttachment((Control)this.radioFromXtoY, -1, 128));
            FormDataFactory.startingWith((Control)this.radioSinceX).top(new FormAttachment((Control)this.radioFromXtoY, 20)).thenRight(this.dateSince.getControl()).top(new FormAttachment((Control)this.radioSinceX, -1, 128));
        } else {
            FormDataFactory.startingWith((Control)this.radioFromXtoY).top(new FormAttachment((Control)this.radioLastTradingDays, 20)).thenRight(this.dateFrom.getControl()).thenRight((Control)lblTo).thenRight(this.dateTo.getControl());
            FormDataFactory.startingWith((Control)this.radioSinceX).top(new FormAttachment((Control)this.radioFromXtoY, 20)).thenRight(this.dateSince.getControl());
        }
        FormDataFactory.startingWith((Control)this.radioYearX).top(new FormAttachment((Control)this.radioSinceX, 20)).thenRight((Control)this.year);
        FormDataFactory.startingWith((Control)this.radioCurrentMonth).top(new FormAttachment((Control)this.radioYearX, 20));
        FormDataFactory.startingWith((Control)this.radioYTD).top(new FormAttachment((Control)this.radioCurrentMonth, 20));
        this.presetFromTemplate();
        this.radioBtnList = Arrays.asList(this.radioLast, this.radioLastDays, this.radioLastTradingDays, this.radioFromXtoY, this.radioSinceX, this.radioYearX, this.radioCurrentMonth, this.radioYTD);
        this.activateRadioOnChange(this.radioLast, new Control[]{this.years, this.months});
        this.activateRadioOnChange(this.radioLastDays, new Control[]{this.days});
        this.activateRadioOnChange(this.radioLastTradingDays, new Control[]{this.tradingDays});
        this.activateRadioOnChange(this.radioFromXtoY, this.dateFrom.getControl(), this.dateTo.getControl());
        this.activateRadioOnChange(this.radioSinceX, this.dateSince.getControl());
        this.activateRadioOnChange(this.radioYearX, new Control[]{this.year});
        return composite;
    }

    private void deselectSelectedRadioButtons(Button radio) {
        this.radioBtnList.stream().filter(btn -> !btn.equals(radio)).filter(Button::getSelection).forEach(btn -> btn.setSelection(false));
    }

    private void activateRadioOnChange(Button radio, Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.addListener(13, event -> {
                this.deselectSelectedRadioButtons(radio);
                radio.setSelection(true);
            });
            ++n2;
        }
    }

    private void presetFromTemplate() {
        if (this.template instanceof ReportingPeriod.LastX) {
            this.radioLast.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.LastXDays) {
            this.radioLastDays.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.LastXTradingDays) {
            this.radioLastTradingDays.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.FromXtoY) {
            this.radioFromXtoY.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.SinceX) {
            this.radioSinceX.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.YearX) {
            this.radioYearX.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.CurrentMonth) {
            this.radioCurrentMonth.setSelection(true);
        } else if (this.template instanceof ReportingPeriod.YearToDate) {
            this.radioYTD.setSelection(true);
        } else {
            throw new IllegalArgumentException();
        }
        Interval interval = this.template.toInterval(LocalDate.now());
        this.dateFrom.setSelection(interval.getStart());
        this.dateSince.setSelection(interval.getStart());
        this.dateTo.setSelection(interval.getEnd());
        Period p = Period.between(interval.getStart(), interval.getEnd());
        this.years.setSelection(p.getYears());
        this.months.setSelection(p.getMonths());
        this.days.setSelection(Dates.daysBetween((LocalDate)interval.getStart(), (LocalDate)interval.getEnd()));
        this.tradingDays.setSelection(Dates.tradingDaysBetween((LocalDate)interval.getStart(), (LocalDate)interval.getEnd()));
        this.year.setSelection(interval.getEnd().getYear());
    }

    protected void okPressed() {
        if (this.radioLast.getSelection()) {
            this.result = new ReportingPeriod.LastX(this.years.getSelection(), this.months.getSelection());
        } else if (this.radioLastDays.getSelection()) {
            this.result = new ReportingPeriod.LastXDays(this.days.getSelection());
        } else if (this.radioLastTradingDays.getSelection()) {
            this.result = new ReportingPeriod.LastXTradingDays(this.tradingDays.getSelection());
        } else if (this.radioFromXtoY.getSelection()) {
            if (this.dateFrom.getSelection() == null || this.dateTo.getSelection() == null) {
                return;
            }
            this.result = new ReportingPeriod.FromXtoY(this.dateFrom.getSelection(), this.dateTo.getSelection());
        } else if (this.radioSinceX.getSelection()) {
            if (this.dateSince.getSelection() == null) {
                return;
            }
            this.result = new ReportingPeriod.SinceX(this.dateSince.getSelection());
        } else if (this.radioYearX.getSelection()) {
            this.result = new ReportingPeriod.YearX(this.year.getSelection());
        } else if (this.radioCurrentMonth.getSelection()) {
            this.result = new ReportingPeriod.CurrentMonth();
        } else if (this.radioYTD.getSelection()) {
            this.result = new ReportingPeriod.YearToDate();
        } else {
            throw new IllegalArgumentException();
        }
        super.okPressed();
    }

    public ReportingPeriod getReportingPeriod() {
        return this.result;
    }
}

