/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.dialogs.palette.CommandPalettePopup;
import name.abuchen.portfolio.ui.editor.Navigation;
import name.abuchen.portfolio.ui.editor.PortfolioPart;

class NavigationElements
implements CommandPalettePopup.ElementProvider {
    @Inject
    private PortfolioPart part;

    NavigationElements() {
    }

    @Override
    public List<CommandPalettePopup.Element> getElements() {
        Navigation navigation = this.part.getClientInput().getNavigation();
        if (navigation == null) {
            return Collections.emptyList();
        }
        ArrayList<CommandPalettePopup.Element> elements = new ArrayList<CommandPalettePopup.Element>();
        navigation.getRoots().forEach(item -> this.addElement(elements, this.part, new ArrayList<Navigation.Item>(Arrays.asList(item))));
        return elements;
    }

    private void addElement(List<CommandPalettePopup.Element> elements, PortfolioPart part, List<Navigation.Item> path) {
        Navigation.Item leaf = path.get(path.size() - 1);
        if (leaf.contains(Navigation.Tag.VIEW)) {
            String subtitle = String.join((CharSequence)" -> ", path.subList(0, path.size() - 1).stream().map(Navigation.Item::getLabel).collect(Collectors.toList()));
            elements.add(new NavigationElement(part, leaf, subtitle));
        }
        leaf.getChildren().forEach(child -> {
            path.add((Navigation.Item)child);
            this.addElement(elements, part, path);
            path.remove(child);
        });
    }

    private static class NavigationElement
    implements CommandPalettePopup.Element {
        private final PortfolioPart part;
        private final Navigation.Item item;
        private final String subtitle;

        public NavigationElement(PortfolioPart part, Navigation.Item item, String subtitle) {
            this.part = part;
            this.item = item;
            this.subtitle = subtitle;
        }

        @Override
        public String getTitel() {
            return this.item.getLabel();
        }

        @Override
        public String getSubtitle() {
            return this.subtitle;
        }

        @Override
        public Images getImage() {
            return this.item.getImage() != null ? this.item.getImage() : Images.VIEW;
        }

        @Override
        public void execute() {
            this.part.activateView(this.item);
        }
    }
}

