/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import com.ibm.icu.text.DecimalFormat;
import java.math.BigDecimal;
import java.text.Format;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import name.abuchen.portfolio.ui.util.CurrencyToStringConverter;
import name.abuchen.portfolio.ui.util.DatePicker;
import name.abuchen.portfolio.ui.util.IValidatingConverter;
import name.abuchen.portfolio.ui.util.SimpleDateTimeDateSelectionProperty;
import name.abuchen.portfolio.ui.util.SimpleDateTimeTimeSelectionProperty;
import name.abuchen.portfolio.ui.util.StringToCurrencyConverter;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.text.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractTransactionDialog
extends TitleAreaDialog {
    public static final int SAVE_AND_NEW_ID = 4711;
    protected AbstractModel model;
    protected DataBindingContext context = new DataBindingContext();
    protected ModelStatusListener status = new ModelStatusListener();
    private boolean hasAtLeastOneSuccessfulEdit = false;

    public AbstractTransactionDialog(Shell parentShell) {
        super(parentShell);
        this.setTitleImage(Images.BANNER.image());
    }

    protected void setModel(AbstractModel model) {
        this.model = model;
    }

    public boolean hasAtLeastOneSuccessfulEdit() {
        return this.hasAtLeastOneSuccessfulEdit;
    }

    public void create() {
        super.create();
        this.setTitle(this.model.getHeading());
        this.setMessage("");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.status.setStatus(AggregateValidationStatus.getStatusMaxSeverity((Collection)this.context.getValidationStatusProviders()));
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.LabelSave, true);
        this.createButton(parent, 4711, Messages.LabelSaveAndNew, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite editArea = new Composite(area, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        editArea.setLayout((Layout)layout);
        this.createFormElements(editArea);
        final IObservableValue calculationStatus = BeanProperties.value((String)"calculationStatus", IStatus.class).observe((Object)this.model);
        this.context.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)calculationStatus.getValue();
            }
        });
        IObservableValue observable = PojoProperties.value((String)"status").observe((Object)this.status);
        this.context.bindValue(observable, (IObservableValue)new AggregateValidationStatus(this.context, 2));
        return editArea;
    }

    protected abstract void createFormElements(Composite var1);

    protected void okPressed() {
        this.model.applyChanges();
        this.hasAtLeastOneSuccessfulEdit = true;
        super.okPressed();
    }

    protected final void buttonPressed(int buttonId) {
        if (buttonId == 4711) {
            this.model.applyChanges();
            this.model.resetToNewTransaction();
            this.hasAtLeastOneSuccessfulEdit = true;
            this.setErrorMessage(null);
            this.getDialogArea().setFocus();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void setAccount(Account account) {
    }

    public void setPortfolio(Portfolio portfolio) {
    }

    public void setSecurity(Security security) {
    }

    protected <T> List<T> including(List<T> list, T element) {
        if (element != null && !list.contains(element)) {
            list.add(0, element);
        }
        return list;
    }

    public class ComboInput {
        public final Label label;
        public final ComboViewer value;
        public final Label currency;

        public ComboInput(Composite editArea, String text) {
            if (text != null) {
                this.label = new Label(editArea, 131072);
                this.label.setText(text);
            } else {
                this.label = null;
            }
            this.value = new ComboViewer(editArea);
            this.value.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.currency = new Label(editArea, 0);
        }

        public IObservableValue<Object> bindValue(String property, String missingValueMessage) {
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setAfterConvertValidator(v -> v != null ? ValidationStatus.ok() : ValidationStatus.error((String)missingValueMessage));
            IViewerObservableValue targetObservable = ViewerProperties.singleSelection().observe((Viewer)this.value);
            IObservableValue modelObservable = BeanProperties.value((String)property).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable, strategy, null);
            return targetObservable;
        }

        public void bindCurrency(String property) {
            ISWTObservableValue targetObservable = WidgetProperties.text().observe((Widget)this.currency);
            IObservableValue modelObservable = BeanProperties.value((String)property).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        }
    }

    public class DateTimeInput {
        public final Label label;
        public final DatePicker date;
        public final CDateTime time;
        public final ImageHyperlink button;

        public DateTimeInput(Composite editArea, String text) {
            this.label = new Label(editArea, 131072);
            this.label.setText(text);
            this.date = new DatePicker(editArea);
            this.time = new CDateTime(editArea, 0x20000001){

                public void setOpen(boolean open) {
                }
            };
            this.time.setFormat(0x800000);
            this.time.setButtonImage(Images.CLOCK.image());
            this.button = new ImageHyperlink(editArea, 0);
            this.button.setImage(Images.CLOCK.image());
        }

        public void bindDate(String property) {
            ISWTObservableValue targetObservable = new SimpleDateTimeDateSelectionProperty().observe((Widget)this.date.getControl());
            IObservableValue modelObservable = BeanProperties.value((String)property).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        }

        public void bindTime(String property) {
            ISWTObservableValue targetObservable = new SimpleDateTimeTimeSelectionProperty().observe((Widget)this.time);
            IObservableValue modelObservable = BeanProperties.value((String)property).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        }

        public void bindButton(final Supplier<LocalTime> supplier, final Consumer<LocalTime> consumer) {
            this.button.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (LocalTime.MIDNIGHT.equals(supplier.get())) {
                        consumer.accept(LocalTime.now());
                    } else {
                        consumer.accept(LocalTime.MIDNIGHT);
                    }
                }
            });
        }
    }

    public class ExchangeRateInput
    extends Input {
        public final ImageHyperlink buttonInvertExchangeRate;

        public ExchangeRateInput(Composite editArea, String text) {
            super(editArea, text);
            this.buttonInvertExchangeRate = new ImageHyperlink(editArea, 0);
            this.buttonInvertExchangeRate.setImage(Images.INVERT_EXCHANGE_RATE.image());
            this.buttonInvertExchangeRate.setToolTipText(Messages.BtnTooltipInvertExchangeRate);
        }

        public void bindInvertAction(final Runnable invertAction) {
            this.buttonInvertExchangeRate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    invertAction.run();
                }
            });
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.buttonInvertExchangeRate.setVisible(visible);
        }
    }

    public class Input {
        public final Label label;
        public final Text value;
        public final Label currency;

        public Input(Composite editArea, String text) {
            this.label = new Label(editArea, 16384);
            this.label.setText(text);
            this.value = new Text(editArea, 133120);
            this.value.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    Input.this.value.selectAll();
                }
            });
            this.currency = new Label(editArea, 0);
        }

        public void bindValue(String property, String description, Values<?> values, boolean isMandatory) {
            StringToCurrencyConverter converter = new StringToCurrencyConverter(values);
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setAfterGetValidator((IValidator)converter);
            strategy.setConverter((IConverter)converter);
            if (isMandatory) {
                strategy.setAfterConvertValidator(convertedValue -> convertedValue != null && convertedValue > 0L ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, description)));
            }
            ISWTObservableValue targetObservable = WidgetProperties.text((int)24).observe((Widget)this.value);
            IObservableValue modelObservable = BeanProperties.value((String)property, Long.class).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable, strategy, new UpdateValueStrategy().setConverter((IConverter)new CurrencyToStringConverter(values)));
        }

        public void bindCurrency(String property) {
            ISWTObservableValue targetObservable = WidgetProperties.text().observe((Widget)this.currency);
            IObservableValue modelObservable = BeanProperties.value((String)property, String.class).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        }

        public void bindBigDecimal(String property, String pattern) {
            DecimalFormat format = new DecimalFormat(pattern);
            IValidatingConverter converter = IValidatingConverter.wrap(StringToNumberConverter.toBigDecimal());
            ISWTObservableValue targetObservable = WidgetProperties.text((int)24).observe((Widget)this.value);
            IObservableValue modelObservable = BeanProperties.value((String)property, BigDecimal.class).observe((Object)AbstractTransactionDialog.this.model);
            AbstractTransactionDialog.this.context.bindValue((IObservableValue)targetObservable, modelObservable, new UpdateValueStrategy().setAfterGetValidator(converter).setConverter(converter), new UpdateValueStrategy().setConverter((IConverter)NumberToStringConverter.fromBigDecimal((Format)format)));
        }

        public void setVisible(boolean visible) {
            this.label.setVisible(visible);
            this.value.setVisible(visible);
            this.currency.setVisible(visible);
        }
    }

    class ModelStatusListener {
        ModelStatusListener() {
        }

        public void setStatus(IStatus status) {
            AbstractTransactionDialog.this.setErrorMessage(status.getSeverity() == 0 ? null : status.getMessage());
            int[] nArray = new int[2];
            nArray[1] = 4711;
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int buttonId = nArray2[n2];
                Button button = AbstractTransactionDialog.this.getButton(buttonId);
                if (button != null) {
                    button.setEnabled(status.getSeverity() == 0);
                }
                ++n2;
            }
        }

        public IStatus getStatus() {
            return ValidationStatus.ok();
        }
    }
}

