/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionModel;
import name.abuchen.portfolio.ui.dialogs.transactions.WarningMessages;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SWTHelper;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AccountTransactionDialog
extends AbstractTransactionDialog {
    @Inject
    private Client client;
    @Preference(value="USE_INDIRECT_QUOTATION")
    @Inject
    private boolean useIndirectQuotation = false;
    private Menu contextMenu;

    @Inject
    public AccountTransactionDialog(@Named(value="activeShell") Shell parentShell) {
        super(parentShell);
    }

    @PostConstruct
    private void createModel(ExchangeRateProviderFactory factory, AccountTransaction.Type type) {
        AccountTransactionModel m = new AccountTransactionModel(this.client, type);
        m.setExchangeRateProviderFactory(factory);
        this.setModel(m);
        List activeAccounts = this.client.getActiveAccounts();
        if (activeAccounts.size() == 1) {
            m.setAccount((Account)activeAccounts.get(0));
        }
    }

    private AccountTransactionModel model() {
        return (AccountTransactionModel)this.model;
    }

    @Override
    protected void createFormElements(Composite editArea) {
        FormDataFactory forms;
        AbstractTransactionDialog.ComboInput securities = null;
        if (this.model().supportsSecurity()) {
            securities = this.setupSecurities(editArea);
        }
        AbstractTransactionDialog.ComboInput accounts = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnAccount);
        accounts.value.setInput(this.including(this.client.getActiveAccounts(), this.model().getAccount()));
        accounts.bindValue(AccountTransactionModel.Properties.account.name(), Messages.MsgMissingAccount);
        accounts.bindCurrency(AccountTransactionModel.Properties.accountCurrencyCode.name());
        AbstractTransactionDialog.DateTimeInput dateTime = new AbstractTransactionDialog.DateTimeInput(this, editArea, Messages.ColumnDate);
        dateTime.bindDate(AccountTransactionModel.Properties.date.name());
        dateTime.bindTime(AccountTransactionModel.Properties.time.name());
        dateTime.bindButton(() -> this.model().getTime(), time -> this.model().setTime((LocalTime)time));
        AbstractTransactionDialog.Input shares = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnShares);
        shares.bindValue(AccountTransactionModel.Properties.shares.name(), Messages.ColumnShares, Values.Share, false);
        shares.setVisible(this.model().supportsShares());
        Button btnShares = new Button(editArea, 1028);
        btnShares.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountTransactionDialog.this.showSharesContextMenu();
            }
        });
        btnShares.setVisible(this.model().supportsShares());
        editArea.addDisposeListener(e -> this.widgetDisposed());
        AbstractTransactionDialog.Input dividendAmount = new AbstractTransactionDialog.Input(this, editArea, Messages.LabelDividendPerShare);
        dividendAmount.bindBigDecimal(AccountTransactionModel.Properties.dividendAmount.name(), "#,##0.0000");
        dividendAmount.bindCurrency(AccountTransactionModel.Properties.fxCurrencyCode.name());
        dividendAmount.setVisible(this.model().supportsShares());
        String totalLabel = this.model().supportsTaxUnits() ? Messages.ColumnGrossValue : this.getTotalLabel();
        AbstractTransactionDialog.Input fxGrossAmount = new AbstractTransactionDialog.Input(this, editArea, totalLabel);
        fxGrossAmount.bindValue(AccountTransactionModel.Properties.fxGrossAmount.name(), totalLabel, Values.Amount, true);
        fxGrossAmount.bindCurrency(AccountTransactionModel.Properties.fxCurrencyCode.name());
        AbstractTransactionDialog.ExchangeRateInput exchangeRate = new AbstractTransactionDialog.ExchangeRateInput(this, editArea, this.useIndirectQuotation ? "/ " : "x ");
        exchangeRate.bindBigDecimal(this.useIndirectQuotation ? AccountTransactionModel.Properties.inverseExchangeRate.name() : AccountTransactionModel.Properties.exchangeRate.name(), Values.ExchangeRate.pattern());
        exchangeRate.bindCurrency(this.useIndirectQuotation ? AccountTransactionModel.Properties.inverseExchangeRateCurrencies.name() : AccountTransactionModel.Properties.exchangeRateCurrencies.name());
        exchangeRate.bindInvertAction(() -> this.model().setExchangeRate(BigDecimal.ONE.divide(this.model().getExchangeRate(), 10, RoundingMode.HALF_DOWN)));
        this.model().addPropertyChangeListener(AccountTransactionModel.Properties.exchangeRate.name(), e -> exchangeRateInput.value.setToolTipText(AbstractModel.createCurrencyToolTip(this.model().getExchangeRate(), this.model().getAccountCurrencyCode(), this.model().getSecurityCurrencyCode())));
        AbstractTransactionDialog.Input grossAmount = new AbstractTransactionDialog.Input(this, editArea, "=");
        grossAmount.bindValue(AccountTransactionModel.Properties.grossAmount.name(), totalLabel, Values.Amount, true);
        grossAmount.bindCurrency(AccountTransactionModel.Properties.accountCurrencyCode.name());
        Label plusForexFees = new Label(editArea, 0);
        plusForexFees.setText("+");
        plusForexFees.setVisible(this.model().supportsFees());
        AbstractTransactionDialog.Input forexFees = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnFees);
        forexFees.bindValue(AccountTransactionModel.Properties.fxFees.name(), Messages.ColumnFees, Values.Amount, false);
        forexFees.bindCurrency(AccountTransactionModel.Properties.securityCurrencyCode.name());
        forexFees.setVisible(this.model().supportsFees());
        AbstractTransactionDialog.Input fees = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnFees);
        fees.bindValue(AccountTransactionModel.Properties.fees.name(), Messages.ColumnFees, Values.Amount, false);
        fees.bindCurrency(AccountTransactionModel.Properties.accountCurrencyCode.name());
        fees.setVisible(this.model().supportsFees());
        fees.label.setVisible(false);
        Label plusForexTaxes = new Label(editArea, 0);
        plusForexTaxes.setText("+");
        plusForexTaxes.setVisible(this.model().supportsTaxUnits());
        AbstractTransactionDialog.Input forexTaxes = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnTaxes);
        forexTaxes.bindValue(AccountTransactionModel.Properties.fxTaxes.name(), Messages.ColumnTaxes, Values.Amount, false);
        forexTaxes.bindCurrency(AccountTransactionModel.Properties.fxCurrencyCode.name());
        forexTaxes.setVisible(this.model().supportsTaxUnits());
        AbstractTransactionDialog.Input taxes = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnTaxes);
        taxes.bindValue(AccountTransactionModel.Properties.taxes.name(), Messages.ColumnTaxes, Values.Amount, false);
        taxes.bindCurrency(AccountTransactionModel.Properties.accountCurrencyCode.name());
        taxes.setVisible(this.model().supportsTaxUnits());
        taxes.label.setVisible(false);
        AbstractTransactionDialog.Input total = new AbstractTransactionDialog.Input(this, editArea, this.getTotalLabel());
        total.bindValue(AccountTransactionModel.Properties.total.name(), Messages.ColumnTotal, Values.Amount, false);
        total.bindCurrency(AccountTransactionModel.Properties.accountCurrencyCode.name());
        total.setVisible(this.model().supportsTaxUnits() || this.model().supportsFees());
        Label lblNote = new Label(editArea, 16384);
        lblNote.setText(Messages.ColumnNote);
        Text valueNote = new Text(editArea, 2818);
        ISWTObservableValue targetNote = WidgetProperties.text((int)24).observe((Widget)valueNote);
        IObservableValue noteObservable = BeanProperties.value((String)AccountTransactionModel.Properties.note.name()).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetNote, noteObservable);
        int widest = SWTHelper.widest(new Control[]{securities != null ? securities.label : null, accounts.label, dateTime.label, shares.label, taxes.label, fees.label, total.label, lblNote, fxGrossAmount.label});
        if (securities != null) {
            forms = FormDataFactory.startingWith(securities.value.getControl(), securities.label).suffix(securities.currency).thenBelow(accounts.value.getControl()).label(accounts.label).suffix(accounts.currency);
            FormDataFactory.startingWith((Control)securities.label).width(widest);
        } else {
            forms = FormDataFactory.startingWith(accounts.value.getControl(), accounts.label).suffix(accounts.currency);
            FormDataFactory.startingWith((Control)accounts.label).width(widest);
        }
        int amountWidth = SWTHelper.amountWidth((Drawable)grossAmount.value);
        int currencyWidth = SWTHelper.currencyWidth((Drawable)fxGrossAmount.currency);
        forms = forms.thenBelow(dateTime.date.getControl()).label(dateTime.label);
        FormDataFactory.startingWith(dateTime.date.getControl()).thenRight((Control)dateTime.time).thenRight((Control)dateTime.button, 0);
        forms.thenBelow((Control)shares.value).width(amountWidth).label(shares.label).suffix((Control)btnShares).thenBelow((Control)fxGrossAmount.value).width(amountWidth).label(fxGrossAmount.label).thenRight((Control)fxGrossAmount.currency).width(currencyWidth).thenRight((Control)exchangeRate.label).thenRight((Control)exchangeRate.value).width(amountWidth).thenRight((Control)exchangeRate.buttonInvertExchangeRate, 0).thenRight((Control)exchangeRate.currency).width(amountWidth).thenRight((Control)grossAmount.label).thenRight((Control)grossAmount.value).width(amountWidth).thenRight((Control)grossAmount.currency).width(currencyWidth);
        if (this.model().supportsShares()) {
            FormDataFactory.startingWith((Control)btnShares).thenRight((Control)dividendAmount.label).thenRight((Control)dividendAmount.value).width(amountWidth).thenRight((Control)dividendAmount.currency).width(currencyWidth);
        }
        forms = FormDataFactory.startingWith((Control)grossAmount.value);
        if (this.model().supportsFees()) {
            forms.thenBelow((Control)fees.value).width(amountWidth).label(fees.label).suffix(fees.currency);
            FormDataFactory.startingWith((Control)fees.value).thenLeft((Control)plusForexFees).thenLeft((Control)forexFees.currency).width(currencyWidth).thenLeft((Control)forexFees.value).width(amountWidth).thenLeft((Control)forexFees.label);
            forms = FormDataFactory.startingWith((Control)fees.value);
        }
        if (this.model().supportsTaxUnits()) {
            forms.thenBelow((Control)taxes.value).width(amountWidth).label(taxes.label).suffix(taxes.currency);
            FormDataFactory.startingWith((Control)taxes.value).thenLeft((Control)plusForexTaxes).thenLeft((Control)forexTaxes.currency).width(currencyWidth).thenLeft((Control)forexTaxes.value).width(amountWidth).thenLeft((Control)forexTaxes.label);
            forms = FormDataFactory.startingWith((Control)taxes.value);
        }
        if (this.model().supportsFees() || this.model().supportsTaxUnits()) {
            forms = forms.thenBelow((Control)total.value).width(amountWidth).label(total.label).thenRight((Control)total.currency).width(currencyWidth);
        }
        forms.thenBelow((Control)valueNote).height(SWTHelper.lineHeight((Control)valueNote) * 3).left(accounts.value.getControl()).right((Control)grossAmount.value).label(lblNote);
        this.model.addPropertyChangeListener(AccountTransactionModel.Properties.exchangeRateCurrencies.name(), event -> {
            String securityCurrency = this.model().getSecurityCurrencyCode();
            String accountCurrency = this.model().getAccountCurrencyCode();
            boolean isFxVisible = securityCurrency.length() > 0 && accountCurrency.length() > 0 && !securityCurrency.equals(accountCurrency);
            exchangeRate.setVisible(isFxVisible);
            grossAmount.setVisible(isFxVisible);
            plusForexFees.setVisible(isFxVisible && this.model().supportsShares());
            forexFees.setVisible(isFxVisible && this.model().supportsShares());
            input3.label.setVisible(!isFxVisible && this.model().supportsFees());
            plusForexTaxes.setVisible(isFxVisible && this.model().supportsShares());
            forexTaxes.setVisible(isFxVisible && this.model().supportsShares());
            input5.label.setVisible(!isFxVisible && this.model().supportsTaxUnits());
            if (!isFxVisible) {
                this.model().setFxTaxes(0L);
                this.model().setFxFees(0L);
            }
            if (isFxVisible) {
                FormDataFactory.startingWith((Control)input.value).thenBelow((Control)(this.model().supportsFees() ? input3.value : input5.value));
            } else {
                FormDataFactory.startingWith((Control)input6.value).thenBelow((Control)(this.model().supportsFees() ? input3.value : input5.value));
            }
            editArea.layout();
        });
        WarningMessages warnings = new WarningMessages(this);
        warnings.add(() -> this.model().getDate().isAfter(LocalDate.now()) ? Messages.MsgDateIsInTheFuture : null);
        this.model.addPropertyChangeListener(AccountTransactionModel.Properties.date.name(), e -> warnings.check());
        this.model.firePropertyChange(AccountTransactionModel.Properties.exchangeRateCurrencies.name(), "", this.model().getExchangeRateCurrencies());
    }

    private AbstractTransactionDialog.ComboInput setupSecurities(Composite editArea) {
        ArrayList<Security> activeSecurities = new ArrayList<Security>();
        activeSecurities.addAll(this.including(this.client.getActiveSecurities(), this.model().getSecurity()));
        if (this.model().supportsOptionalSecurity() && !activeSecurities.contains(AccountTransactionModel.EMPTY_SECURITY)) {
            activeSecurities.add(0, AccountTransactionModel.EMPTY_SECURITY);
            if (this.model().getSecurity() == null) {
                this.model().setSecurity(AccountTransactionModel.EMPTY_SECURITY);
            }
        }
        AbstractTransactionDialog.ComboInput securities = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnSecurity);
        securities.value.setInput(activeSecurities);
        securities.bindValue(AccountTransactionModel.Properties.security.name(), Messages.MsgMissingSecurity);
        securities.bindCurrency(AccountTransactionModel.Properties.securityCurrencyCode.name());
        return securities;
    }

    private void showSharesContextMenu() {
        if (this.contextMenu == null) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(this::sharesMenuAboutToShow);
            this.contextMenu = menuMgr.createContextMenu((Control)this.getShell());
        }
        this.contextMenu.setVisible(true);
    }

    private void sharesMenuAboutToShow(IMenuManager manager) {
        manager.add((IAction)new LabelOnly(Messages.DividendsDialogTitleShares));
        CurrencyConverterImpl converter = new CurrencyConverterImpl(this.model.getExchangeRateProviderFactory(), this.client.getBaseCurrency());
        ClientSnapshot snapshot = ClientSnapshot.create((Client)this.client, (CurrencyConverter)converter, (LocalDate)this.model().getDate());
        if (snapshot != null && this.model().getSecurity() != null) {
            PortfolioSnapshot jointPortfolio = snapshot.getJointPortfolio();
            this.addAction(manager, jointPortfolio, Messages.ColumnSharesOwned);
            List list = snapshot.getPortfolios();
            if (list.size() > 1) {
                for (PortfolioSnapshot ps : list) {
                    this.addAction(manager, ps, ps.getPortfolio().getName());
                }
            }
        }
        manager.add((IAction)new Action(Messages.DividendsDialogLabelSpecialDistribution){

            public void run() {
                AccountTransactionDialog.this.model().setShares(0L);
            }
        });
    }

    private void addAction(IMenuManager manager, PortfolioSnapshot portfolio, String label) {
        final SecurityPosition position = (SecurityPosition)portfolio.getPositionsBySecurity().get(this.model().getSecurity());
        if (position != null) {
            Action action = new Action(MessageFormat.format(Messages.DividendsDialogLabelPortfolioSharesHeld, Values.Share.format((Object)position.getShares()), label, Values.Date.format((Object)portfolio.getTime()))){

                public void run() {
                    AccountTransactionDialog.this.model().setShares(position.getShares());
                }
            };
            manager.add((IAction)action);
        }
    }

    private void widgetDisposed() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
    }

    private String getTotalLabel() {
        switch (this.model().getType()) {
            case REMOVAL: 
            case INTEREST_CHARGE: 
            case FEES: 
            case TAXES: {
                return Messages.ColumnDebitNote;
            }
            case DEPOSIT: 
            case INTEREST: 
            case DIVIDENDS: 
            case FEES_REFUND: 
            case TAX_REFUND: {
                return Messages.ColumnCreditNote;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAccount(Account account) {
        this.model().setAccount(account);
    }

    @Override
    public void setSecurity(Security security) {
        this.model().setSecurity(security);
    }

    public void setTransaction(Account account, AccountTransaction transaction) {
        this.model().setSource(account, transaction);
    }
}

