/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransferModel;
import name.abuchen.portfolio.ui.dialogs.transactions.WarningMessages;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AccountTransferDialog
extends AbstractTransactionDialog {
    @Inject
    private Client client;
    @Preference(value="USE_INDIRECT_QUOTATION")
    @Inject
    private boolean useIndirectQuotation = false;

    @Inject
    public AccountTransferDialog(@Named(value="activeShell") Shell parentShell) {
        super(parentShell);
    }

    @PostConstruct
    private void createModel(ExchangeRateProviderFactory factory) {
        AccountTransferModel m = new AccountTransferModel(this.client);
        m.setExchangeRateProviderFactory(factory);
        this.setModel(m);
    }

    private AccountTransferModel model() {
        return (AccountTransferModel)this.model;
    }

    @Override
    protected void createFormElements(Composite editArea) {
        AbstractTransactionDialog.ComboInput source = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnAccountFrom);
        source.value.setInput(this.including(this.client.getActiveAccounts(), this.model().getSourceAccount()));
        IObservableValue<Object> sourceObservable = source.bindValue(AccountTransferModel.Properties.sourceAccount.name(), Messages.MsgAccountFromMissing);
        source.bindCurrency(AccountTransferModel.Properties.sourceAccountCurrency.name());
        AbstractTransactionDialog.ComboInput target = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnAccountTo);
        target.value.setInput(this.including(this.client.getActiveAccounts(), this.model().getTargetAccount()));
        IObservableValue<Object> targetObservable = target.bindValue(AccountTransferModel.Properties.targetAccount.name(), Messages.MsgAccountToMissing);
        target.bindCurrency(AccountTransferModel.Properties.targetAccountCurrency.name());
        AccountsMustBeDifferentValidator validator = new AccountsMustBeDifferentValidator(sourceObservable, targetObservable);
        this.context.addValidationStatusProvider((ValidationStatusProvider)validator);
        AbstractTransactionDialog.DateTimeInput dateTime = new AbstractTransactionDialog.DateTimeInput(this, editArea, Messages.ColumnDate);
        dateTime.bindDate(AccountTransferModel.Properties.date.name());
        dateTime.bindTime(AccountTransferModel.Properties.time.name());
        dateTime.bindButton(() -> this.model().getTime(), time -> this.model().setTime((LocalTime)time));
        AbstractTransactionDialog.Input fxAmount = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnAmount);
        fxAmount.bindValue(AccountTransferModel.Properties.fxAmount.name(), Messages.ColumnAmount, Values.Amount, true);
        fxAmount.bindCurrency(AccountTransferModel.Properties.sourceAccountCurrency.name());
        AbstractTransactionDialog.ExchangeRateInput exchangeRate = new AbstractTransactionDialog.ExchangeRateInput(this, editArea, this.useIndirectQuotation ? "/ " : "x ");
        exchangeRate.bindBigDecimal(this.useIndirectQuotation ? AccountTransferModel.Properties.inverseExchangeRate.name() : AccountTransferModel.Properties.exchangeRate.name(), Values.ExchangeRate.pattern());
        exchangeRate.bindCurrency(this.useIndirectQuotation ? AccountTransferModel.Properties.inverseExchangeRateCurrencies.name() : AccountTransferModel.Properties.exchangeRateCurrencies.name());
        exchangeRate.bindInvertAction(() -> this.model().setExchangeRate(BigDecimal.ONE.divide(this.model().getExchangeRate(), 10, RoundingMode.HALF_DOWN)));
        this.model().addPropertyChangeListener(AccountTransferModel.Properties.exchangeRate.name(), e -> exchangeRateInput.value.setToolTipText(AbstractModel.createCurrencyToolTip(this.model().getExchangeRate(), this.model().getTargetAccountCurrency(), this.model().getSourceAccountCurrency())));
        AbstractTransactionDialog.Input amount = new AbstractTransactionDialog.Input(this, editArea, "=");
        amount.bindValue(AccountTransferModel.Properties.amount.name(), Messages.ColumnAmount, Values.Amount, true);
        amount.bindCurrency(AccountTransferModel.Properties.targetAccountCurrency.name());
        Label lblNote = new Label(editArea, 16384);
        lblNote.setText(Messages.ColumnNote);
        Text valueNote = new Text(editArea, 2818);
        ISWTObservableValue targetNote = WidgetProperties.text((int)24).observe((Widget)valueNote);
        IObservableValue noteObservable = BeanProperties.value((String)AccountTransferModel.Properties.note.name()).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetNote, noteObservable);
        int amountWidth = SWTHelper.amountWidth((Drawable)amount.value);
        int currencyWidth = SWTHelper.currencyWidth((Drawable)fxAmount.currency);
        FormDataFactory forms = FormDataFactory.startingWith(source.value.getControl(), source.label).suffix(source.currency).thenBelow(target.value.getControl()).label(target.label).suffix(target.currency).thenBelow(dateTime.date.getControl()).label(dateTime.label).thenRight((Control)dateTime.time).thenRight((Control)dateTime.button, 0);
        forms.thenBelow((Control)fxAmount.value).width(amountWidth).label(fxAmount.label).thenRight((Control)fxAmount.currency).width(currencyWidth).thenRight((Control)exchangeRate.label).thenRight((Control)exchangeRate.value).width(amountWidth).thenRight((Control)exchangeRate.buttonInvertExchangeRate, 0).thenRight((Control)exchangeRate.currency).width(amountWidth).thenRight((Control)amount.label).thenRight((Control)amount.value).width(amountWidth).suffix(amount.currency, currencyWidth).thenBelow((Control)valueNote).height(SWTHelper.lineHeight((Control)valueNote) * 3).left(target.value.getControl()).right((Control)amount.value).label(lblNote);
        int widest = SWTHelper.widest(new Control[]{source.label, target.label, dateTime.label, fxAmount.label, lblNote});
        FormDataFactory.startingWith((Control)source.label).width(widest);
        this.model.addPropertyChangeListener(AccountTransferModel.Properties.exchangeRateCurrencies.name(), event -> {
            String sourceCurrency = this.model().getSourceAccountCurrency();
            String targetCurrency = this.model().getTargetAccountCurrency();
            boolean visible = sourceCurrency.length() > 0 && targetCurrency.length() > 0 && !sourceCurrency.equals(targetCurrency);
            exchangeRate.setVisible(visible);
            amount.setVisible(visible);
        });
        WarningMessages warnings = new WarningMessages(this);
        warnings.add(() -> this.model().getDate().isAfter(LocalDate.now()) ? Messages.MsgDateIsInTheFuture : null);
        this.model.addPropertyChangeListener(AccountTransferModel.Properties.date.name(), e -> warnings.check());
        this.model.firePropertyChange(AccountTransferModel.Properties.exchangeRateCurrencies.name(), "", this.model().getExchangeRateCurrencies());
    }

    @Override
    public void setAccount(Account account) {
        this.model().setSourceAccount(account);
    }

    public void setEntry(AccountTransferEntry entry) {
        this.model().setSource(entry);
    }

    private final class AccountsMustBeDifferentValidator
    extends MultiValidator {
        IObservableValue<?> source;
        IObservableValue<?> target;

        public AccountsMustBeDifferentValidator(IObservableValue<?> source, IObservableValue<?> target) {
            this.source = source;
            this.target = target;
        }

        protected IStatus validate() {
            Object from = this.source.getValue();
            Object to = this.target.getValue();
            return from != null && to != null && from != to ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.MsgAccountMustBeDifferent);
        }
    }
}

