/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import com.ibm.icu.text.MessageFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class AccountTransferModel
extends AbstractModel {
    private final Client client;
    private AccountTransferEntry source;
    private Account sourceAccount;
    private Account targetAccount;
    private LocalDate date = LocalDate.now();
    private LocalTime time = LocalTime.MIDNIGHT;
    private long fxAmount;
    private BigDecimal exchangeRate = BigDecimal.ONE;
    private long amount;
    private String note;
    private IStatus calculationStatus = ValidationStatus.ok();

    public AccountTransferModel(Client client) {
        this.client = client;
    }

    @Override
    public String getHeading() {
        return Messages.LabelTransfer;
    }

    @Override
    public void applyChanges() {
        AccountTransferEntry t;
        if (this.sourceAccount == null) {
            throw new UnsupportedOperationException(Messages.MsgAccountFromMissing);
        }
        if (this.targetAccount == null) {
            throw new UnsupportedOperationException(Messages.MsgAccountToMissing);
        }
        if (this.source != null && this.sourceAccount.equals(this.source.getOwner((Transaction)this.source.getSourceTransaction())) && this.targetAccount.equals(this.source.getOwner((Transaction)this.source.getTargetTransaction()))) {
            t = this.source;
        } else {
            if (this.source != null) {
                TransactionOwner owner = this.source.getOwner((Transaction)this.source.getSourceTransaction());
                owner.deleteTransaction((Transaction)this.source.getSourceTransaction(), this.client);
                this.source = null;
            }
            t = new AccountTransferEntry(this.sourceAccount, this.targetAccount);
            t.getSourceTransaction().setCurrencyCode(this.sourceAccount.getCurrencyCode());
            t.getTargetTransaction().setCurrencyCode(this.targetAccount.getCurrencyCode());
            t.insert();
        }
        t.setDate(LocalDateTime.of(this.date, this.time));
        t.setNote(this.note);
        AccountTransaction sourceTransaction = t.getSourceTransaction();
        sourceTransaction.clearUnits();
        if (this.sourceAccount.getCurrencyCode().equals(this.targetAccount.getCurrencyCode())) {
            sourceTransaction.setAmount(this.amount);
            t.getTargetTransaction().setAmount(this.amount);
        } else {
            sourceTransaction.setAmount(this.fxAmount);
            t.getTargetTransaction().setAmount(this.amount);
            Transaction.Unit forex = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of((String)this.sourceAccount.getCurrencyCode(), (long)this.fxAmount), Money.of((String)this.targetAccount.getCurrencyCode(), (long)this.amount), this.getInverseExchangeRate());
            sourceTransaction.addUnit(forex);
        }
    }

    @Override
    public void resetToNewTransaction() {
        this.source = null;
        this.setFxAmount(0L);
        this.setAmount(0L);
        this.setNote(null);
    }

    public void setSource(AccountTransferEntry entry) {
        this.source = entry;
        this.sourceAccount = (Account)entry.getOwner((Transaction)entry.getSourceTransaction());
        this.targetAccount = (Account)entry.getOwner((Transaction)entry.getTargetTransaction());
        LocalDateTime transactionDate = entry.getSourceTransaction().getDateTime();
        this.date = transactionDate.toLocalDate();
        this.time = transactionDate.toLocalTime();
        this.note = entry.getSourceTransaction().getNote();
        this.fxAmount = entry.getSourceTransaction().getAmount();
        this.amount = entry.getTargetTransaction().getAmount();
        Optional forex = entry.getSourceTransaction().getUnit(Transaction.Unit.Type.GROSS_VALUE);
        this.exchangeRate = forex.isPresent() && ((Transaction.Unit)forex.get()).getAmount().getCurrencyCode().equals(this.sourceAccount.getCurrencyCode()) && ((Transaction.Unit)forex.get()).getForex().getCurrencyCode().equals(this.targetAccount.getCurrencyCode()) ? ExchangeRate.inverse((BigDecimal)((Transaction.Unit)forex.get()).getExchangeRate()) : BigDecimal.ONE;
    }

    @Override
    public IStatus getCalculationStatus() {
        return this.calculationStatus;
    }

    private IStatus calculateStatus() {
        long upper = Math.round((double)this.fxAmount * this.exchangeRate.add(BigDecimal.valueOf(1.0E-4)).doubleValue());
        long lower = Math.round((double)this.fxAmount * this.exchangeRate.add(BigDecimal.valueOf(-1.0E-4)).doubleValue());
        if (this.amount < lower || this.amount > upper) {
            return ValidationStatus.error((String)Messages.MsgErrorConvertedAmount);
        }
        if (this.amount == 0L || this.fxAmount == 0L) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnTotal}));
        }
        return ValidationStatus.ok();
    }

    public Account getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(Account account) {
        String oldCurrencyCode = this.getSourceAccountCurrency();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.sourceAccount = account;
        this.firePropertyChange(Properties.sourceAccount.name(), this.sourceAccount, this.sourceAccount);
        this.firePropertyChange(Properties.sourceAccountCurrency.name(), oldCurrencyCode, this.getSourceAccountCurrency());
        this.firePropertyChange(Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        this.updateExchangeRate();
    }

    public Account getTargetAccount() {
        return this.targetAccount;
    }

    public void setTargetAccount(Account account) {
        String oldCurrencyCode = this.getTargetAccountCurrency();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.targetAccount = account;
        this.firePropertyChange(Properties.targetAccount.name(), this.targetAccount, this.targetAccount);
        this.firePropertyChange(Properties.targetAccountCurrency.name(), oldCurrencyCode, this.getTargetAccountCurrency());
        this.firePropertyChange(Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        this.updateExchangeRate();
    }

    private void updateExchangeRate() {
        if (this.getSourceAccountCurrency().equals(this.getTargetAccountCurrency())) {
            this.setExchangeRate(BigDecimal.ONE);
            return;
        }
        if (this.source != null) {
            return;
        }
        ExchangeRateTimeSeries series = this.getExchangeRateProviderFactory().getTimeSeries(this.getSourceAccountCurrency(), this.getTargetAccountCurrency());
        if (series != null) {
            this.setExchangeRate(series.lookupRate(this.date).orElse(new ExchangeRate(this.date, BigDecimal.ONE)).getValue());
        } else {
            this.setExchangeRate(BigDecimal.ONE);
        }
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
        this.firePropertyChange(Properties.date.name(), this.date, this.date);
        this.updateExchangeRate();
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setTime(LocalTime time) {
        this.time = time;
        this.firePropertyChange(Properties.time.name(), this.time, this.time);
    }

    public long getFxAmount() {
        return this.fxAmount;
    }

    public void setFxAmount(long foreignCurrencyAmount) {
        this.fxAmount = foreignCurrencyAmount;
        this.firePropertyChange(Properties.fxAmount.name(), this.fxAmount, this.fxAmount);
        this.triggerAmount(Math.round(this.exchangeRate.doubleValue() * (double)foreignCurrencyAmount));
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        BigDecimal newRate = exchangeRate == null ? BigDecimal.ZERO : exchangeRate;
        BigDecimal oldInverseRate = this.getInverseExchangeRate();
        this.exchangeRate = newRate;
        this.firePropertyChange(Properties.exchangeRate.name(), this.exchangeRate, this.exchangeRate);
        this.firePropertyChange(Properties.inverseExchangeRate.name(), oldInverseRate, this.getInverseExchangeRate());
        this.triggerAmount(Math.round(newRate.doubleValue() * (double)this.fxAmount));
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getInverseExchangeRate() {
        return BigDecimal.ONE.divide(this.exchangeRate, 10, RoundingMode.HALF_DOWN);
    }

    public void setInverseExchangeRate(BigDecimal rate) {
        this.setExchangeRate(BigDecimal.ONE.divide(rate, 10, RoundingMode.HALF_DOWN));
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.triggerAmount(amount);
        if (this.fxAmount != 0L) {
            BigDecimal newExchangeRate = BigDecimal.valueOf(amount).divide(BigDecimal.valueOf(this.fxAmount), 10, RoundingMode.HALF_UP);
            BigDecimal oldInverseRate = this.getInverseExchangeRate();
            this.exchangeRate = newExchangeRate;
            this.firePropertyChange(Properties.exchangeRate.name(), this.exchangeRate, this.exchangeRate);
            this.firePropertyChange(Properties.inverseExchangeRate.name(), oldInverseRate, this.getInverseExchangeRate());
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerAmount(long amount) {
        this.amount = amount;
        this.firePropertyChange(Properties.amount.name(), this.amount, this.amount);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.firePropertyChange(Properties.note.name(), this.note, this.note);
    }

    public String getSourceAccountCurrency() {
        return this.sourceAccount != null ? this.sourceAccount.getCurrencyCode() : "";
    }

    public String getTargetAccountCurrency() {
        return this.targetAccount != null ? this.targetAccount.getCurrencyCode() : "";
    }

    public String getExchangeRateCurrencies() {
        return String.format("%s/%s", this.getSourceAccountCurrency(), this.getTargetAccountCurrency());
    }

    public String getInverseExchangeRateCurrencies() {
        return String.format("%s/%s", this.getTargetAccountCurrency(), this.getSourceAccountCurrency());
    }

    public static enum Properties {
        sourceAccount,
        targetAccount,
        date,
        time,
        fxAmount,
        exchangeRate,
        inverseExchangeRate,
        amount,
        note,
        sourceAccountCurrency,
        targetAccountCurrency,
        exchangeRateCurrencies,
        inverseExchangeRateCurrencies,
        calculationStatus;

    }
}

