/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class InvestmentPlanModel
extends AbstractModel {
    public static final Account DELIVERY = new Account(Messages.InvestmentPlanOptionDelivery);
    private static final Portfolio DEPOSIT = new Portfolio(Messages.InvestmentPlanOptionDeposit);
    private final Client client;
    private InvestmentPlan source;
    private String name;
    private Security security;
    private Portfolio portfolio;
    private Account account;
    private boolean autoGenerate;
    private LocalDate start = LocalDate.now();
    private int interval = 1;
    private long amount;
    private long fees;
    private IStatus calculationStatus = ValidationStatus.ok();

    public InvestmentPlanModel(Client client, Class<? extends Transaction> planType) {
        this.client = client;
        if (planType == AccountTransaction.class) {
            this.portfolio = DEPOSIT;
        }
    }

    @Override
    public String getHeading() {
        return this.source != null ? Messages.InvestmentPlanTitleEditPlan : Messages.InvestmentPlanTitleNewPlan;
    }

    @Override
    public void applyChanges() {
        if (this.security == null && !DEPOSIT.equals(this.portfolio)) {
            throw new UnsupportedOperationException(Messages.MsgMissingSecurity);
        }
        if (this.portfolio == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingPortfolio);
        }
        if (this.account == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingAccount);
        }
        InvestmentPlan plan = this.source;
        if (plan == null) {
            plan = new InvestmentPlan();
            this.client.addPlan(plan);
        }
        plan.setName(this.name);
        plan.setSecurity(this.portfolio.equals(DEPOSIT) ? null : this.security);
        plan.setPortfolio(this.portfolio.equals(DEPOSIT) ? null : this.portfolio);
        plan.setAccount(this.account.equals(DELIVERY) ? null : this.account);
        plan.setAutoGenerate(this.autoGenerate);
        plan.setStart(this.start);
        plan.setInterval(this.interval);
        plan.setAmount(this.amount);
        plan.setFees(this.fees);
    }

    @Override
    public void resetToNewTransaction() {
        this.source = null;
        this.setName(null);
        this.setAutoGenerate(false);
        this.setAmount(0L);
        this.setFees(0L);
    }

    public void setSource(InvestmentPlan plan) {
        this.source = plan;
        this.name = plan.getName();
        this.security = plan.getSecurity();
        this.portfolio = plan.getPortfolio() != null ? plan.getPortfolio() : DEPOSIT;
        this.account = plan.getAccount() != null ? plan.getAccount() : DELIVERY;
        this.autoGenerate = plan.isAutoGenerate();
        this.start = plan.getStart();
        this.interval = plan.getInterval();
        this.amount = plan.getAmount();
        this.fees = plan.getFees();
    }

    @Override
    public IStatus getCalculationStatus() {
        return this.calculationStatus;
    }

    private IStatus calculateStatus() {
        if (this.account != null && this.account.equals(DELIVERY) && this.portfolio != null && this.portfolio.equals(DEPOSIT)) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnPeer}));
        }
        if (this.name == null || this.name.trim().length() == 0) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnName}));
        }
        if (this.security == null && this.portfolio != null && !this.portfolio.equals(DEPOSIT)) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.MsgMissingSecurity}));
        }
        if (this.amount == 0L) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnAmount}));
        }
        return ValidationStatus.ok();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(Properties.name.name(), this.name, this.name);
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        String oldSecurityCurrency = this.getSecurityCurrencyCode();
        String oldTransactionCurrency = this.getTransactionCurrencyCode();
        this.security = security;
        this.firePropertyChange(Properties.security.name(), this.security, this.security);
        this.firePropertyChange(Properties.securityCurrencyCode.name(), oldSecurityCurrency, this.getSecurityCurrencyCode());
        this.firePropertyChange(Properties.transactionCurrencyCode.name(), oldTransactionCurrency, this.getTransactionCurrencyCode());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        String oldTransactionCurrency = this.getTransactionCurrencyCode();
        if (DEPOSIT.equals(portfolio)) {
            this.security = null;
            this.firePropertyChange(Properties.security.name(), this.security, null);
        }
        this.portfolio = portfolio;
        this.firePropertyChange(Properties.portfolio.name(), this.portfolio, this.portfolio);
        this.firePropertyChange(Properties.transactionCurrencyCode.name(), oldTransactionCurrency, this.getTransactionCurrencyCode());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        String oldAccountCurrency = this.getAccountCurrencyCode();
        String oldTransactionCurrency = this.getTransactionCurrencyCode();
        this.account = account;
        this.firePropertyChange(Properties.account.name(), this.account, this.account);
        this.firePropertyChange(Properties.accountCurrencyCode.name(), oldAccountCurrency, this.getAccountCurrencyCode());
        this.firePropertyChange(Properties.transactionCurrencyCode.name(), oldTransactionCurrency, this.getTransactionCurrencyCode());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }

    public void setAutoGenerate(boolean autoGenerate) {
        this.autoGenerate = autoGenerate;
        this.firePropertyChange(Properties.autoGenerate.name(), this.autoGenerate, this.autoGenerate);
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
        this.firePropertyChange(Properties.start.name(), this.start, this.start);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.firePropertyChange(Properties.interval.name(), this.interval, this.interval);
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
        this.firePropertyChange(Properties.amount.name(), this.amount, this.amount);
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getFees() {
        return this.fees;
    }

    public void setFees(long fees) {
        this.fees = fees;
        this.firePropertyChange(Properties.fees.name(), this.fees, this.fees);
    }

    public String getSecurityCurrencyCode() {
        return this.security != null ? this.security.getCurrencyCode() : "";
    }

    public String getAccountCurrencyCode() {
        return this.account != null && !DELIVERY.equals(this.account) ? this.account.getCurrencyCode() : "";
    }

    public String getReferenceAccountCurrencyCode() {
        return this.portfolio != null && !DEPOSIT.equals(this.portfolio) ? this.portfolio.getReferenceAccount().getCurrencyCode() : "";
    }

    public String getTransactionCurrencyCode() {
        return this.account != null && !DELIVERY.equals(this.account) ? this.account.getCurrencyCode() : this.getReferenceAccountCurrencyCode();
    }

    public static enum Properties {
        calculationStatus,
        name,
        security,
        securityCurrencyCode,
        portfolio,
        account,
        accountCurrencyCode,
        start,
        interval,
        amount,
        fees,
        transactionCurrencyCode,
        autoGenerate;

    }
}

