/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferModel;
import name.abuchen.portfolio.ui.dialogs.transactions.StockSplitWarning;
import name.abuchen.portfolio.ui.dialogs.transactions.WarningMessages;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SecurityTransferDialog
extends AbstractTransactionDialog {
    private Client client;

    @Inject
    public SecurityTransferDialog(@Named(value="activeShell") Shell parentShell, Client client, ExchangeRateProviderFactory factory) {
        super(parentShell);
        this.client = client;
        SecurityTransferModel m = new SecurityTransferModel(client);
        m.setExchangeRateProviderFactory(factory);
        this.setModel(m);
    }

    private SecurityTransferModel model() {
        return (SecurityTransferModel)this.model;
    }

    @Override
    protected void createFormElements(Composite editArea) {
        AbstractTransactionDialog.ComboInput securities = new AbstractTransactionDialog.ComboInput(editArea, Messages.ColumnSecurity);
        securities.value.setInput(this.including(this.client.getActiveSecurities(), this.model().getSecurity()));
        securities.bindValue(SecurityTransferModel.Properties.security.name(), Messages.MsgMissingSecurity);
        securities.bindCurrency(SecurityTransferModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.ComboInput source = new AbstractTransactionDialog.ComboInput(editArea, Messages.ColumnAccountFrom);
        source.value.setInput(this.including(this.client.getActivePortfolios(), this.model().getSourcePortfolio()));
        IObservableValue<Object> sourceObservable = source.bindValue(SecurityTransferModel.Properties.sourcePortfolio.name(), Messages.MsgPortfolioFromMissing);
        source.bindCurrency(SecurityTransferModel.Properties.sourcePortfolioLabel.name());
        AbstractTransactionDialog.ComboInput target = new AbstractTransactionDialog.ComboInput(editArea, Messages.ColumnAccountTo);
        target.value.setInput(this.including(this.client.getActivePortfolios(), this.model().getTargetPortfolio()));
        IObservableValue<Object> targetObservable = target.bindValue(SecurityTransferModel.Properties.targetPortfolio.name(), Messages.MsgPortfolioToMissing);
        target.bindCurrency(SecurityTransferModel.Properties.targetPortfolioLabel.name());
        PortfoliosMustBeDifferentValidator validator = new PortfoliosMustBeDifferentValidator(sourceObservable, targetObservable);
        this.context.addValidationStatusProvider((ValidationStatusProvider)validator);
        AbstractTransactionDialog.DateTimeInput dateTime = new AbstractTransactionDialog.DateTimeInput(editArea, Messages.ColumnDate);
        dateTime.bindDate(SecurityTransferModel.Properties.date.name());
        dateTime.bindTime(SecurityTransferModel.Properties.time.name());
        dateTime.bindButton(() -> this.model().getTime(), time -> this.model().setTime((LocalTime)time));
        AbstractTransactionDialog.Input shares = new AbstractTransactionDialog.Input(editArea, Messages.ColumnShares);
        shares.bindValue(SecurityTransferModel.Properties.shares.name(), Messages.ColumnShares, Values.Share, true);
        AbstractTransactionDialog.Input quote = new AbstractTransactionDialog.Input(editArea, "x " + Messages.ColumnQuote);
        quote.bindBigDecimal(SecurityTransferModel.Properties.quote.name(), Values.Quote.pattern());
        quote.bindCurrency(SecurityTransferModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.Input amount = new AbstractTransactionDialog.Input(editArea, "=");
        amount.bindValue(SecurityTransferModel.Properties.amount.name(), Messages.ColumnAmount, Values.Amount, true);
        amount.bindCurrency(SecurityTransferModel.Properties.securityCurrencyCode.name());
        Label lblNote = new Label(editArea, 16384);
        lblNote.setText(Messages.ColumnNote);
        Text valueNote = new Text(editArea, 2818);
        ISWTObservableValue targetNote = WidgetProperties.text((int)24).observe((Widget)valueNote);
        IObservableValue noteObservable = BeanProperties.value((String)SecurityTransferModel.Properties.note.name()).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetNote, noteObservable);
        int amountWidth = SWTHelper.amountWidth((Drawable)amount.value);
        int currencyWidth = SWTHelper.currencyWidth((Drawable)amount.currency);
        FormDataFactory.startingWith(securities.value.getControl(), securities.label).suffix(securities.currency).thenBelow(source.value.getControl()).label(source.label).suffix(source.currency).thenBelow(target.value.getControl()).label(target.label).suffix(target.currency).thenBelow(dateTime.date.getControl()).label(dateTime.label).thenRight((Control)dateTime.time).thenRight((Control)dateTime.button, 0);
        FormDataFactory.startingWith(dateTime.date.getControl()).thenBelow((Control)shares.value).width(amountWidth).label(shares.label).thenRight((Control)quote.label).thenRight((Control)quote.value).width(amountWidth).thenRight((Control)quote.currency).width(currencyWidth).thenRight((Control)amount.label).thenRight((Control)amount.value).width(amountWidth).thenRight((Control)amount.currency).width(currencyWidth);
        FormDataFactory.startingWith((Control)shares.value).thenBelow((Control)valueNote).height(SWTHelper.lineHeight((Control)valueNote) * 3).left(securities.value.getControl()).right((Control)amount.value).label(lblNote);
        int widest = SWTHelper.widest(new Control[]{securities.label, source.label, target.label, dateTime.label, shares.label, lblNote});
        FormDataFactory.startingWith((Control)securities.label).width(widest);
        WarningMessages warnings = new WarningMessages(this);
        warnings.add(() -> LocalDateTime.of(this.model().getDate(), this.model().getTime()).isAfter(LocalDateTime.now()) ? Messages.MsgDateIsInTheFuture : null);
        warnings.add(() -> new StockSplitWarning().check(this.model().getSecurity(), this.model().getDate()));
        this.model.addPropertyChangeListener(SecurityTransferModel.Properties.security.name(), e -> warnings.check());
        this.model.addPropertyChangeListener(SecurityTransferModel.Properties.date.name(), e -> warnings.check());
    }

    @Override
    public void setSecurity(Security security) {
        this.model().setSecurity(security);
    }

    @Override
    public void setPortfolio(Portfolio portfolio) {
        this.model().setSourcePortfolio(portfolio);
    }

    public void setEntry(PortfolioTransferEntry entry) {
        this.model().setSource(entry);
    }

    private final class PortfoliosMustBeDifferentValidator
    extends MultiValidator {
        IObservableValue<?> source;
        IObservableValue<?> target;

        public PortfoliosMustBeDifferentValidator(IObservableValue<?> source, IObservableValue<?> target) {
            this.source = source;
            this.target = target;
        }

        protected IStatus validate() {
            Object from = this.source.getValue();
            Object to = this.target.getValue();
            return from != null && to != null && from != to ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.MsgPortfolioMustBeDifferent);
        }
    }
}

