/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dnd;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.online.impl.PortfolioReportNet;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dnd.AbstractDropAdapter;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.jobs.UpdateQuotesJob;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportFromURLDropAdapter
extends AbstractDropAdapter {
    public static final Pattern URL_PATTERN = Pattern.compile("^https://www.portfolio-report.net/securities/([^/]+)/?");
    private final PortfolioPart part;

    private ImportFromURLDropAdapter(Transfer transfer, Control control, PortfolioPart part) {
        super(transfer, control);
        this.part = part;
    }

    public static void attach(Control control, PortfolioPart part) {
        new ImportFromURLDropAdapter((Transfer)URLTransfer.getInstance(), control, part);
    }

    @Override
    protected boolean isValidEvent(DropTargetEvent e) {
        if (!super.isValidEvent(e)) {
            return false;
        }
        if (Util.isWindows()) {
            if (e.data == null && !this.extractEventData(e)) {
                return false;
            }
            Optional<String> url = this.getUrlFromEvent(e);
            return url.isPresent() && URL_PATTERN.matcher(url.get()).matches();
        }
        return true;
    }

    private boolean extractEventData(DropTargetEvent e) {
        Object data;
        TransferData transferData = e.currentDataType;
        if (transferData != null && (data = URLTransfer.getInstance().nativeToJava(transferData)) != null) {
            e.data = data;
            return true;
        }
        return false;
    }

    @Override
    public void doDrop(DropTargetEvent event) {
        Optional<String> url = this.getUrlFromEvent(event);
        if (!url.isPresent()) {
            event.detail = 0;
            return;
        }
        Matcher matcher = URL_PATTERN.matcher(url.get());
        if (!matcher.matches()) {
            event.detail = 0;
            return;
        }
        String onlineId = matcher.group(1);
        DropTarget source = (DropTarget)event.getSource();
        Display display = source.getDisplay();
        display.asyncExec(() -> this.createNewSecurity((String)url.get(), onlineId));
    }

    private Optional<String> getUrlFromEvent(DropTargetEvent event) {
        Object eventData = event.data;
        if (!(eventData instanceof String)) {
            return Optional.empty();
        }
        return Optional.of(((String)eventData).split(System.getProperty("line.separator"))[0]);
    }

    private void createNewSecurity(String url, String onlineId) {
        try {
            Dialog dialog;
            Optional result = new PortfolioReportNet().getUpdatedValues(onlineId);
            if (!result.isPresent()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)MessageFormat.format((String)Messages.MsgErrorNoInvestmentVehicleFoundAtURL, (Object[])new Object[]{url}));
                return;
            }
            Security newSecurity = new Security();
            newSecurity.setName(((SecuritySearchProvider.ResultItem)result.get()).getName());
            newSecurity.setOnlineId(onlineId);
            PortfolioReportNet.updateWith((Security)newSecurity, (SecuritySearchProvider.ResultItem)((SecuritySearchProvider.ResultItem)result.get()));
            QuoteFeed feed = Factory.getQuoteFeedProvider((String)"PORTFOLIO-REPORT");
            List exchanges = feed.getExchanges(newSecurity, new ArrayList());
            if (!exchanges.isEmpty()) {
                newSecurity.setFeed(feed.getId());
                newSecurity.setPropertyValue(SecurityProperty.Type.FEED, "PORTFOLIO-REPORT-MARKET", ((Exchange)exchanges.get(0)).getId());
            }
            if ((dialog = (Dialog)this.part.make(EditSecurityDialog.class, newSecurity)).open() == 0) {
                this.part.getClient().addSecurity(newSecurity);
                new UpdateQuotesJob(this.part.getClient(), newSecurity).schedule();
            }
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
        }
    }
}

