/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.editor.ToolBarPlusChevronLayout;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public abstract class AbstractFinanceView {
    @Inject
    private IEclipseContext context;
    @Inject
    private PortfolioPart part;
    private Composite top;
    private String titleText;
    private Label title;
    private ToolBarManager viewToolBar;
    private ToolBarManager actionToolBar;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<Menu> contextMenus = new ArrayList<Menu>();

    protected abstract String getDefaultTitle();

    protected String getTitle() {
        return this.titleText;
    }

    protected final void updateTitle(String title) {
        if (!this.title.isDisposed()) {
            String escaped = TextUtil.tooltip((String)title);
            boolean isEqual = escaped.equals(this.title.getText());
            this.titleText = title;
            this.title.setText(escaped);
            if (!isEqual) {
                this.title.getParent().layout(true);
            }
        }
    }

    public void notifyModelUpdated() {
    }

    public PortfolioPart getPart() {
        return this.part;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.part.getPreferenceStore();
    }

    public Client getClient() {
        return this.part.getClient();
    }

    public void markDirty() {
        this.part.markDirty();
    }

    public Shell getActiveShell() {
        return Display.getDefault().getActiveShell();
    }

    public final void createViewControl(Composite parent) {
        this.top = new Composite(parent, 0);
        int spacing = "win32".equals(Platform.getOS()) ? 1 : 0;
        GridLayoutFactory.fillDefaults().spacing(spacing, spacing).applyTo(this.top);
        Control header = this.createHeader(this.top);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
        Control body = this.createBody(this.top);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(body);
        this.top.addDisposeListener(e -> this.dispose());
    }

    protected abstract Control createBody(Composite var1);

    private final Control createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        header.setBackground(Colors.WHITE);
        Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)JFaceResources.getFont((String)"org.eclipse.jface.headerfont")).setStyle(1));
        this.titleText = this.getDefaultTitle();
        this.title = new Label(header, 0);
        this.title.setText(TextUtil.tooltip((String)this.titleText));
        this.title.setFont(boldFont);
        this.title.setForeground(Colors.SIDEBAR_TEXT);
        this.title.setBackground(header.getBackground());
        Composite wrapper = new Composite(header, 0);
        wrapper.setBackground(header.getBackground());
        this.viewToolBar = new ToolBarManager(0x820000);
        this.addViewButtons(this.viewToolBar);
        ToolBar tb1 = this.viewToolBar.createControl(wrapper);
        tb1.setBackground(header.getBackground());
        wrapper.setLayout((Layout)new ToolBarPlusChevronLayout(wrapper));
        this.actionToolBar = new ToolBarManager(0x820000);
        this.addButtons(this.actionToolBar);
        ToolBar tb2 = this.actionToolBar.createControl(header);
        tb2.setBackground(header.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).applyTo(header);
        GridDataFactory.fillDefaults().applyTo((Control)this.title);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)wrapper);
        GridDataFactory.fillDefaults().applyTo((Control)tb2);
        return header;
    }

    protected void addViewButtons(ToolBarManager toolBarManager) {
    }

    protected void addButtons(ToolBarManager toolBarManager) {
    }

    protected ToolBarManager getViewToolBarManager() {
        return this.viewToolBar;
    }

    protected ToolBarManager getToolBarManager() {
        return this.actionToolBar;
    }

    protected final void hookContextMenu(Control control, IMenuListener listener) {
        this.doCreateContextMenu(control, true, listener);
    }

    protected final Menu createContextMenu(Control control, IMenuListener listener) {
        return this.doCreateContextMenu(control, false, listener);
    }

    private final Menu doCreateContextMenu(Control control, boolean hook, IMenuListener listener) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(listener);
        Menu contextMenu = menuMgr.createContextMenu(control);
        if (hook) {
            control.setMenu(contextMenu);
        }
        this.contextMenus.add(contextMenu);
        return contextMenu;
    }

    public void dispose() {
        this.viewToolBar.dispose();
        this.actionToolBar.dispose();
        for (Menu contextMenu : this.contextMenus) {
            if (contextMenu.isDisposed()) continue;
            contextMenu.dispose();
        }
        this.resourceManager.dispose();
        this.context.dispose();
    }

    public final Control getControl() {
        return this.top;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public final <T> T make(Class<T> type, Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return (T)ContextInjectionFactory.make(type, (IEclipseContext)this.context);
        }
        IEclipseContext c2 = EclipseContextFactory.create();
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            c2.set(param.getClass().getName(), param);
            ++n2;
        }
        return (T)ContextInjectionFactory.make(type, (IEclipseContext)this.context, (IEclipseContext)c2);
    }

    public final void inject(Object object) {
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)this.context);
    }

    public final IEclipseContext getContext() {
        return this.context;
    }

    public <T> T getFromContext(Class<T> clazz) {
        return (T)this.context.get(clazz);
    }
}

