/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Watchlist;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.dnd.ImportFromFileDropAdapter;
import name.abuchen.portfolio.ui.dnd.ImportFromURLDropAdapter;
import name.abuchen.portfolio.ui.dnd.SecurityTransfer;
import name.abuchen.portfolio.ui.editor.Navigation;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.editor.Sidebar;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class ClientEditorSidebar {
    private PortfolioPart editor;
    private Sidebar<Navigation.Item> sidebar;

    public ClientEditorSidebar(PortfolioPart editor) {
        this.editor = editor;
    }

    public Control createSidebarControl(Composite parent) {
        Sidebar.Model<Navigation.Item> model = new Sidebar.Model<Navigation.Item>(){

            @Override
            public Stream<Navigation.Item> getElements() {
                return ClientEditorSidebar.this.editor.getClientInput().getNavigation().getRoots().filter(i -> !i.contains(Navigation.Tag.HIDE));
            }

            @Override
            public Stream<Navigation.Item> getChildren(Navigation.Item item) {
                return item.getChildren().filter(i -> !i.contains(Navigation.Tag.HIDE));
            }

            @Override
            public String getLabel(Navigation.Item item) {
                return item.getLabel();
            }

            @Override
            public Optional<Images> getImage(Navigation.Item item) {
                return Optional.ofNullable(item.getImage());
            }

            @Override
            public void select(Navigation.Item item) {
                if (item.getViewClass() != null) {
                    ClientEditorSidebar.this.editor.activateView(item);
                }
            }

            @Override
            public IMenuListener getActionMenu(Navigation.Item item) {
                return item.getActionMenu();
            }

            @Override
            public IMenuListener getContextMenu(Navigation.Item item) {
                return item.getContextMenu();
            }
        };
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        this.sidebar = new Sidebar<Navigation.Item>((Composite)scrolledComposite, model);
        this.editor.getClientInput().getNavigation().findAll(item -> item.getParameter() instanceof Watchlist).forEach(this::setupWatchlistDnD);
        scrolledComposite.setContent(this.sidebar);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        parent.getParent().addControlListener(ControlListener.controlResizedAdapter(e -> scrolledComposite.setMinSize(this.sidebar.computeSize(-1, -1))));
        Navigation.Listener listener = item -> {
            this.sidebar.rebuild();
            this.editor.getClientInput().getNavigation().findAll(i -> i.getParameter() instanceof Watchlist).forEach(this::setupWatchlistDnD);
            scrolledComposite.setMinSize(this.sidebar.computeSize(-1, -1));
            this.sidebar.layout(true);
            this.sidebar.redraw();
            this.sidebar.update();
        };
        this.editor.getClientInput().getNavigation().addListener(listener);
        this.sidebar.addDisposeListener(e -> this.editor.getClientInput().getNavigation().removeListener(listener));
        ImportFromURLDropAdapter.attach(this.sidebar, this.editor);
        ImportFromFileDropAdapter.attach(this.sidebar, this.editor);
        return scrolledComposite;
    }

    public void select(Navigation.Item item) {
        this.sidebar.select(item);
    }

    private void setupWatchlistDnD(Navigation.Item item) {
        final Watchlist watchlist = (Watchlist)item.getParameter();
        DropTargetAdapter dropTargetListener = new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                List<Security> securities;
                if (SecurityTransfer.getTransfer().isSupportedType(event.currentDataType) && (securities = SecurityTransfer.getTransfer().getSecurities()) != null) {
                    for (Security security : securities) {
                        if (!ClientEditorSidebar.this.editor.getClient().getSecurities().contains(security)) {
                            security = security.deepCopy();
                            ClientEditorSidebar.this.editor.getClient().addSecurity(security);
                        }
                        if (watchlist.getSecurities().contains(security)) continue;
                        watchlist.addSecurity(security);
                    }
                    ClientEditorSidebar.this.editor.getClient().touch();
                }
            }
        };
        this.sidebar.addDropSupport(item, 2, new Transfer[]{SecurityTransfer.getTransfer()}, (DropTargetListener)dropTargetListener);
    }
}

