/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.util.ProgressMonitorFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ClientProgressProvider
extends ProgressProvider {
    @Inject
    private Client client;
    @Inject
    private ProgressMonitorFactory factory;
    @Inject
    private UISynchronize sync;
    private Label label;

    @PostConstruct
    public void setup() {
        this.factory.addProgressProvider(this);
    }

    protected void disposed() {
        this.factory.removeProgressProvider(this);
    }

    @PostConstruct
    public void createComposite(Composite parent) {
        this.label = new Label(parent, 16384);
        this.label.setText("");
        parent.addDisposeListener(e -> this.disposed());
    }

    public IProgressMonitor createMonitor(Job job) {
        if (job.belongsTo((Object)this.client)) {
            final MonitorImpl monitor = new MonitorImpl();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    monitor.done();
                }
            });
            return monitor;
        }
        return null;
    }

    public Control getControl() {
        return this.label;
    }

    private class MonitorImpl
    implements IProgressMonitor {
        private boolean isCanceled = false;

        private MonitorImpl() {
        }

        public void beginTask(String name, int totalWork) {
            this.internalSetText(name);
        }

        public void done() {
            this.internalSetText("");
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void setCanceled(boolean value) {
            this.isCanceled = value;
        }

        public void setTaskName(String name) {
            this.internalSetText(name);
        }

        public void subTask(String name) {
            this.internalSetText(name);
        }

        public void worked(int work) {
        }

        private void internalSetText(String text) {
            ClientProgressProvider.this.sync.asyncExec(() -> {
                if (!ClientProgressProvider.this.label.isDisposed()) {
                    ClientProgressProvider.this.label.setText(text);
                }
            });
        }
    }
}

