/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.util.Colors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public final class Sidebar<I>
extends Composite {
    public static final int STEP = 10;
    private Color selectionForeground = Colors.SIDEBAR_TEXT;
    private Color selectionBackground = Colors.SIDEBAR_BACKGROUND_SELECTED;
    private Font boldFont;
    private Font sectionFont;
    private final Model<I> model;
    private List<Entry> entries = new ArrayList<Entry>();
    private Entry selection = null;
    private Entry focus = null;

    public Sidebar(Composite parent, Model<I> model) {
        super(parent, 0);
        this.model = model;
        this.setData("org.eclipse.e4.ui.css.CssClassName", "sidebar");
        this.setLayout((Layout)new FormLayout());
        this.setFont(this.getFont());
        this.registerListeners();
        this.rebuild();
    }

    public void rebuild() {
        ArrayList<Entry> existingList = new ArrayList<Entry>(this.entries);
        ArrayList<Entry> targetList = new ArrayList<Entry>();
        this.model.getElements().forEach(item -> this.build(0, item, existingList, targetList));
        existingList.forEach(Widget::dispose);
        if (this.selection != null && this.selection.isDisposed()) {
            this.selection = null;
        }
        this.entries = targetList;
    }

    private void build(int indent, I item, List<Entry> existingList, List<Entry> targetList) {
        Entry entry = existingList.stream().filter(i -> item.equals(i.getSubject())).findAny().orElseGet(() -> new Entry(this, item));
        entry.setIndent(indent);
        IMenuListener contextMenu = this.model.getContextMenu(item);
        if (contextMenu != null) {
            entry.addContextMenu(contextMenu);
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        int offset = indent == 0 ? 20 : 0;
        data.top = targetList.isEmpty() ? new FormAttachment(0, 5) : new FormAttachment((Control)targetList.get(targetList.size() - 1), offset);
        entry.setLayoutData(data);
        entry.redraw();
        existingList.remove((Object)entry);
        targetList.add(entry);
        this.model.getChildren(item).forEach(child -> this.build(indent + 10, child, existingList, targetList));
    }

    public void select(I subject) {
        Entry previous = this.selection;
        this.selection = subject == null ? null : (Entry)this.entries.stream().filter(e -> e.getSubject().equals(subject)).findAny().orElse(null);
        if (previous != null && !previous.isDisposed()) {
            previous.redraw();
        }
        if (this.selection != null) {
            this.selection.redraw();
        }
    }

    public void addDropSupport(I subject, int operations, Transfer[] transferTypes, final DropTargetListener listener) {
        Optional<Entry> entry = this.entries.stream().filter(e -> e.getSubject().equals(subject)).findAny();
        if (!entry.isPresent()) {
            return;
        }
        final Entry target = entry.get();
        if (target.getData("DropTarget") != null) {
            return;
        }
        DropTarget dropTarget = new DropTarget((Control)target, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event) {
                listener.dropAccept(event);
            }

            public void drop(DropTargetEvent event) {
                listener.drop(event);
            }

            public void dragOver(DropTargetEvent event) {
                listener.dragOver(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                listener.dragOperationChanged(event);
            }

            public void dragLeave(DropTargetEvent event) {
                listener.dragLeave(event);
                target.setIsDragTarget(false);
                target.redraw();
            }

            public void dragEnter(DropTargetEvent event) {
                listener.dragEnter(event);
                target.setIsDragTarget(true);
                target.redraw();
            }
        });
    }

    private void registerListeners() {
        this.addDisposeListener(e -> this.widgetDisposed());
        this.addKeyListener(KeyListener.keyPressedAdapter(this::keyPressed));
        this.addTraverseListener(event -> {
            boolean bl = event.doit = true;
        });
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Entry previous = Sidebar.this.focus;
                Sidebar.this.focus = null;
                if (previous != null) {
                    previous.redraw();
                }
            }

            public void focusGained(FocusEvent e) {
                Sidebar.this.focus = Sidebar.this.selection != null ? Sidebar.this.selection : Sidebar.this.entries.get(0);
                Sidebar.this.focus.redraw();
            }
        });
    }

    private void widgetDisposed() {
        this.boldFont.dispose();
        this.sectionFont.dispose();
    }

    private void keyPressed(KeyEvent e) {
        if (this.focus != null && (e.keyCode == 0x1000001 || e.keyCode == 0x1000002)) {
            int pos = this.entries.indexOf((Object)this.focus);
            if ((pos += e.keyCode == 0x1000001 ? -1 : 1) >= 0 && pos < this.entries.size()) {
                Entry previous = this.focus;
                this.focus = this.entries.get(pos);
                previous.redraw();
                this.focus.redraw();
            }
        } else if (this.focus != null && e.keyCode == 32) {
            this.model.select(this.focus.getSubject());
        } else {
            e.doit = false;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
        if (this.sectionFont != null && !this.sectionFont.isDisposed()) {
            this.sectionFont.dispose();
        }
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(1);
        this.boldFont = new Font((Device)Display.getDefault(), fontData);
        if ("macosx".equals(Platform.getOS())) {
            fontData.setHeight(fontData.getHeight() + 1);
        }
        this.sectionFont = new Font((Device)Display.getDefault(), fontData);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        this.selectionForeground = selectionForeground;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
    }

    private class Entry
    extends Canvas {
        private static final int MARGIN_X = 6;
        private static final int MARGIN_Y = 4;
        private final I subject;
        private int indent;
        private Image image;
        private Menu contextMenu;
        private Menu actionMenu;
        private boolean isDragTarget;

        public Entry(Composite parent, I subject) {
            super(parent, 524288);
            this.subject = Objects.requireNonNull(subject);
            this.image = Sidebar.this.model.getImage(subject).map(Images::image).orElse(null);
            if (this.image == null && Sidebar.this.model.getActionMenu(subject) != null) {
                this.image = Images.PLUS.image();
            }
            this.addDisposeListener(this::handleDispose);
            this.addPaintListener(this::handlePaint);
            this.addMouseListener(MouseListener.mouseDownAdapter(this::handleMouseDown));
        }

        public I getSubject() {
            return this.subject;
        }

        public void addContextMenu(IMenuListener listener) {
            if (this.contextMenu != null) {
                this.contextMenu.dispose();
            }
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(listener);
            this.contextMenu = menuMgr.createContextMenu((Control)this);
            this.setMenu(this.contextMenu);
        }

        public void setIsDragTarget(boolean isDragTarget) {
            this.isDragTarget = isDragTarget;
        }

        public void setIndent(int indent) {
            this.indent = indent;
        }

        private void showMenu(IMenuListener listener) {
            if (this.actionMenu != null) {
                this.actionMenu.dispose();
            }
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(listener);
            this.actionMenu = menuMgr.createContextMenu((Control)this);
            this.actionMenu.setVisible(true);
        }

        private void handleDispose(DisposeEvent event) {
            if (this.contextMenu != null) {
                this.contextMenu.dispose();
            }
            if (this.actionMenu != null) {
                this.actionMenu.dispose();
            }
        }

        private void handleMouseDown(MouseEvent event) {
            if (event.button == 1) {
                IMenuListener action = Sidebar.this.model.getActionMenu(this.subject);
                if (action != null) {
                    boolean doIt = true;
                    if (this.image != null) {
                        Rectangle clientArea = this.getClientArea();
                        Rectangle imgBounds = this.image.getBounds();
                        boolean bl = doIt = event.x >= clientArea.width - imgBounds.width - 6 && event.x <= clientArea.width - 6;
                    }
                    if (doIt) {
                        this.showMenu(action);
                        return;
                    }
                }
                Sidebar.this.model.select(this.subject);
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int height = 0;
            String label = Sidebar.this.model.getLabel(this.subject);
            if (label != null) {
                GC gc = new GC((Drawable)this);
                gc.setFont(Sidebar.this.getFont());
                Point extent = gc.stringExtent(label);
                gc.dispose();
                height = Math.max(height, extent.y);
            }
            return new Point(wHint, height + 8);
        }

        private void handlePaint(PaintEvent e) {
            GC gc = e.gc;
            Color oldBackground = gc.getBackground();
            Color oldForeground = gc.getForeground();
            Rectangle bounds = this.getClientArea();
            boolean hasFocus = Objects.equals((Object)Sidebar.this.focus, (Object)this);
            if (Objects.equals((Object)Sidebar.this.selection, (Object)this)) {
                gc.setBackground(Sidebar.this.selectionBackground);
                gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                gc.setForeground(Sidebar.this.selectionForeground);
                gc.setFont(Sidebar.this.boldFont);
            } else {
                gc.setBackground(Sidebar.this.getBackground());
                gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                if (this.indent > 0) {
                    gc.setForeground(Sidebar.this.getForeground());
                    gc.setFont(this.isDragTarget ? Sidebar.this.boldFont : Sidebar.this.getFont());
                } else {
                    gc.setForeground(this.isDragTarget ? Colors.ICON_ORANGE : Sidebar.this.getForeground());
                    gc.setFont(Sidebar.this.sectionFont);
                }
            }
            String label = Sidebar.this.model.getLabel(this.subject);
            int x = bounds.x + 6 + this.indent;
            int width = bounds.width;
            if (this.image != null) {
                Rectangle imgBounds = this.image.getBounds();
                int offset = (imgBounds.height - gc.stringExtent((String)label).y) / 2;
                if (this.indent == 0) {
                    gc.drawImage(this.image, bounds.width - imgBounds.width - 6, bounds.y + 4 - offset);
                    width = width - imgBounds.width - 6 - 1;
                } else {
                    gc.drawImage(this.image, x, bounds.y + 4 - offset);
                    x += imgBounds.width + 5;
                }
            }
            gc.setClipping(new Rectangle(bounds.x, bounds.y, width, bounds.height));
            gc.drawText(label, x, bounds.y + 4, true);
            if (hasFocus) {
                Point extent = gc.textExtent(label);
                gc.drawLine(x - 1, bounds.y + 4 + extent.y - 1, x + extent.x - 1, bounds.y + 4 + extent.y - 1);
            }
            gc.setClipping(null);
            gc.setBackground(oldBackground);
            gc.setForeground(oldForeground);
        }
    }

    public static interface Model<I> {
        public Stream<I> getElements();

        public Stream<I> getChildren(I var1);

        public String getLabel(I var1);

        public Optional<Images> getImage(I var1);

        public void select(I var1);

        public IMenuListener getActionMenu(I var1);

        public IMenuListener getContextMenu(I var1);
    }
}

