/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.Optional;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.UnityDesktopHelper;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class MenuHelper {
    private MenuHelper() {
    }

    static boolean isClientPartActive(MPart part) {
        if (UnityDesktopHelper.isUnity()) {
            return true;
        }
        return part != null && part.getObject() instanceof PortfolioPart && ((PortfolioPart)part.getObject()).getClient() != null;
    }

    static Optional<Client> getActiveClient(MPart part) {
        return MenuHelper.getActiveClientInput(part).map(ClientInput::getClient);
    }

    static Optional<ClientInput> getActiveClientInput(MPart part) {
        return MenuHelper.getActiveClientInput(part, true);
    }

    static Optional<ClientInput> getActiveClientInput(MPart part, boolean showWarning) {
        if (part == null || !(part.getObject() instanceof PortfolioPart) || ((PortfolioPart)part.getObject()).getClient() == null) {
            if (showWarning) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.MsgNoFileOpen, (String)Messages.MsgNoFileOpenText);
            }
            return Optional.empty();
        }
        return Optional.of(((PortfolioPart)part.getObject()).getClientInput());
    }
}

