/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.File;
import java.text.MessageFormat;
import javax.inject.Named;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class SaveAsFileHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part) {
        return MenuHelper.isClientPartActive(part);
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, @Named(value="name.abuchen.portfolio.ui.param.extension") String extension, @Named(value="name.abuchen.portfolio.ui.param.encryptionmethod") @Optional String encryptionMethod) {
        if (!MenuHelper.getActiveClientInput(part).isPresent()) {
            return;
        }
        if (extension == null) {
            throw new IllegalArgumentException("Missing file extension parameter");
        }
        if ("AES256".equals(encryptionMethod) && !ClientFactory.isKeyLengthSupported((int)256)) {
            new JurisdictionFilesDownloadDialog(shell).open();
            return;
        }
        ((PortfolioPart)part.getObject()).doSaveAs(shell, extension, encryptionMethod);
    }

    private static class JurisdictionFilesDownloadDialog
    extends MessageDialog {
        public JurisdictionFilesDownloadDialog(Shell parentShell) {
            super(parentShell, Messages.JurisdictionFilesDownloadTitle, null, Messages.JurisdictionFilesDownloadMessage, 5, new String[]{IDialogConstants.OK_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
            String javaVersion = System.getProperty("java.version");
            String downloadURL = null;
            downloadURL = javaVersion.startsWith("1.8") ? "http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html" : "http://www.oracle.com/technetwork/java/javase/downloads/";
            File target = new File(System.getProperty("java.home"), "lib/security");
            String message = MessageFormat.format(Messages.JurisdictionFilesDownloadExplanation, downloadURL, target.getAbsolutePath());
            Link explanation = new Link(container, 0);
            explanation.setText(message);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)explanation);
            explanation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DesktopAPI.browse(String.valueOf(event.text));
                }
            });
            return explanation;
        }
    }
}

