/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.handlers.SelectReportingCurrencyHandler;
import name.abuchen.portfolio.util.Pair;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class SelectReportingCurrencyMenuContribution {
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(@Named(value="e4ActivePart") MPart part, List<MMenuElement> menuItems) {
        Optional<ClientInput> clientInput = MenuHelper.getActiveClientInput(part, false);
        if (!clientInput.isPresent()) {
            return;
        }
        PortfolioPart portfolioPart = (PortfolioPart)part.getObject();
        Client client = clientInput.get().getClient();
        client.getUsedCurrencies().forEach(currency -> {
            boolean bl = menuItems.add(this.createMenu((CurrencyUnit)currency, portfolioPart));
        });
        menuItems.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        List available = CurrencyUnit.getAvailableCurrencyUnitsGrouped();
        for (Pair pair : available) {
            MMenu submenu = MMenuFactory.INSTANCE.createMenu();
            submenu.setLabel((String)pair.getLeft());
            menuItems.add((MMenuElement)submenu);
            ((List)pair.getRight()).forEach(currency -> {
                boolean bl = submenu.getChildren().add(this.createMenu((CurrencyUnit)currency, portfolioPart));
            });
        }
    }

    private MMenuElement createMenu(CurrencyUnit currency, PortfolioPart part) {
        MDirectMenuItem menuItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        menuItem.setLabel(currency.getLabel());
        menuItem.setType(ItemType.CHECK);
        menuItem.setContributorURI("platform:/plugin/name.abuchen.portfolio.ui");
        menuItem.setContributionURI("bundleclass://name.abuchen.portfolio.ui/" + SelectReportingCurrencyHandler.class.getName());
        menuItem.getTransientData().put(CurrencyUnit.class.getName(), currency);
        menuItem.getTransientData().put(PortfolioPart.class.getName(), part);
        return menuItem;
    }
}

