/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.EnumSet;
import java.util.Set;
import javax.inject.Named;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.jobs.SyncOnlineSecuritiesJob;
import name.abuchen.portfolio.ui.jobs.UpdateDividendsJob;
import name.abuchen.portfolio.ui.jobs.UpdateQuotesJob;
import name.abuchen.portfolio.ui.selection.SelectionService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Shell;

public class UpdateQuotesHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part) {
        return MenuHelper.isClientPartActive(part);
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, SelectionService selectionService, @Named(value="name.abuchen.portfolio.ui.param.only-current-security") @Optional String onlyCurrentSecurity) {
        MenuHelper.getActiveClient(part).ifPresent(client -> {
            if (Boolean.parseBoolean(onlyCurrentSecurity)) {
                selectionService.getSelection((Client)client).ifPresent(s -> new UpdateQuotesJob((Client)client, s.getSecurity()).schedule());
            } else {
                new UpdateQuotesJob((Client)client, (Set<UpdateQuotesJob.Target>)EnumSet.allOf(UpdateQuotesJob.Target.class)).schedule();
                new SyncOnlineSecuritiesJob((Client)client).schedule(2000L);
                new UpdateDividendsJob((Client)client).schedule(5000L);
            }
        });
    }
}

