/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.Navigation;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.handlers.OpenViewHandler;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class ViewNavigationMenuContribution {
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(@Named(value="e4ActivePart") MPart part, List<MMenuElement> menuItems) {
        Optional<ClientInput> clientInput = MenuHelper.getActiveClientInput(part, false);
        if (!clientInput.isPresent()) {
            return;
        }
        PortfolioPart portfolioPart = (PortfolioPart)part.getObject();
        clientInput.get().getNavigation().getRoots().forEach(item -> this.addMenuItem(0, (Navigation.Item)item, menuItems, portfolioPart));
    }

    private void addMenuItem(int depth, Navigation.Item item, List<MMenuElement> menuItems, PortfolioPart part) {
        if (item.getViewClass() == null) {
            menuItems.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        }
        MMenuElement menuItem = this.createMenu(item, part);
        if (depth > 1) {
            menuItem.setLabel("- " + menuItem.getLabel());
        }
        menuItems.add(menuItem);
        item.getChildren().forEach(child -> this.addMenuItem(depth + 1, (Navigation.Item)child, menuItems, part));
    }

    private MMenuElement createMenu(Navigation.Item item, PortfolioPart part) {
        MDirectMenuItem menuItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        menuItem.setLabel(item.getLabel());
        if (item.getImage() != null) {
            menuItem.setIconURI(item.getImage().getImageURI());
        }
        menuItem.setContributorURI("platform:/plugin/name.abuchen.portfolio.ui");
        menuItem.setContributionURI("bundleclass://name.abuchen.portfolio.ui/" + OpenViewHandler.class.getName());
        menuItem.getTransientData().put(Navigation.Item.class.getName(), item);
        menuItem.getTransientData().put(PortfolioPart.class.getName(), part);
        return menuItem;
    }
}

