/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.jobs;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class CreateInvestmentPlanTxJob
extends AbstractClientJob {
    private Job startAfterOtherJob;
    private ExchangeRateProviderFactory factory;

    public CreateInvestmentPlanTxJob(Client client, ExchangeRateProviderFactory factory) {
        super(client, Messages.InvestmentPlanAutoCreationJob);
        this.factory = factory;
    }

    public void startAfter(Job otherJob) {
        this.startAfterOtherJob = otherJob;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.startAfterOtherJob != null) {
                this.startAfterOtherJob.join();
            }
            HashMap tx = new HashMap();
            CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
            this.getClient().getPlans().stream().filter(InvestmentPlan::isAutoGenerate).forEach(plan -> {
                try {
                    List transactions = plan.generateTransactions((CurrencyConverter)converter);
                    if (!transactions.isEmpty()) {
                        tx.put(plan, transactions);
                    }
                }
                catch (IOException e) {
                    PortfolioPlugin.log(e);
                }
            });
            if (!tx.isEmpty()) {
                Display.getDefault().asyncExec(() -> {
                    String message;
                    if (tx.size() == 1) {
                        Map.Entry entry = tx.entrySet().iterator().next();
                        message = MessageFormat.format((String)Messages.InvestmentPlanTxCreated, (Object[])new Object[]{((InvestmentPlan)entry.getKey()).getName(), ((List)entry.getValue()).size()});
                    } else {
                        int count = tx.values().stream().mapToInt(List::size).sum();
                        StringBuilder builder = new StringBuilder();
                        builder.append(MessageFormat.format((String)Messages.InvestmentPlanTxForMultiplePlansCreated, (Object[])new Object[]{count}));
                        for (Map.Entry entry : tx.entrySet()) {
                            builder.append(MessageFormat.format((String)"\n{0}: {1}", (Object[])new Object[]{((InvestmentPlan)entry.getKey()).getName(), ((List)entry.getValue()).size()}));
                        }
                        message = builder.toString();
                    }
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.LabelInfo, (String)message);
                });
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Status.OK_STATUS;
    }
}

