/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import name.abuchen.portfolio.ui.log.LogEntry;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;

@Creatable
@Singleton
public class LogEntryCache
implements ILogListener {
    private LinkedList<LogEntry> entries = new LinkedList();
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void init() {
        Platform.addLogListener((ILogListener)this);
    }

    @PreDestroy
    public void dispose() {
        Platform.removeLogListener((ILogListener)this);
    }

    public void logging(IStatus status, String plugin) {
        LogEntry entry = this.createEntry(status);
        this.entries.add(entry);
        if (this.entries.size() > 100) {
            this.entries.removeFirst();
        }
        this.eventBroker.post("errorlog/created", (Object)entry);
    }

    private LogEntry createEntry(IStatus status) {
        LogEntry entry = new LogEntry(status.getSeverity(), new Date(), status.getMessage());
        if (status.getException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            status.getException().printStackTrace(pw);
            entry.setStacktrace(sw.toString());
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                entry.addChild(this.createEntry(s));
                ++n2;
            }
        }
        return entry;
    }

    public List<LogEntry> getEntries() {
        return new ArrayList<LogEntry>(this.entries);
    }

    public void clear() {
        this.entries.clear();
        this.eventBroker.post("errorlog/cleared", null);
    }
}

