/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.log;

import java.io.File;
import java.text.MessageFormat;
import javax.inject.Named;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Shell;

public class OpenErrorLogFileHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="instanceLocation") Location instanceLocation, MApplication app, EPartService partService, EModelService modelService) {
        File logfile = new File(instanceLocation.getURL().getFile(), ".metadata/.log");
        if (!logfile.exists()) {
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)MessageFormat.format(Messages.MsgErrorOpeningFile, logfile.getAbsoluteFile()));
        } else {
            MPart part = partService.createPart("name.abuchen.portfolio.ui.part.textviewer");
            part.getPersistedState().put("file", logfile.getAbsolutePath());
            MPartStack stack = (MPartStack)modelService.find("name.abuchen.portfolio.ui.partstack.main", (MUIElement)app);
            stack.getChildren().add(part);
            partService.showPart(part, EPartService.PartState.ACTIVATE);
        }
    }
}

