/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.parts;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.RecentFilesCache;
import name.abuchen.portfolio.ui.util.swt.StyledLabel;
import name.abuchen.portfolio.util.BuildInfo;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class WelcomePart {
    private static final String OPEN = "open:";
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EPartService partService;
    @Inject
    private RecentFilesCache recentFiles;
    private Composite recentFilesComposite;
    private Font boldFont;
    private Font bigFont;

    @PostConstruct
    public void createComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(Colors.WHITE);
        GridLayoutFactory.fillDefaults().margins(20, 20).applyTo(container);
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)container.getFont());
        this.boldFont = fontDescriptor.setStyle(1).createFont((Device)container.getDisplay());
        this.bigFont = fontDescriptor.increaseHeight(20).createFont((Device)container.getDisplay());
        container.addDisposeListener(e -> {
            this.boldFont.dispose();
            this.bigFont.dispose();
        });
        this.createHeader(container);
        this.createContent(container);
    }

    private void createHeader(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setBackground(container.getBackground());
        composite.setLayout((Layout)new FormLayout());
        Label image = new Label(composite, 0);
        image.setBackground(composite.getBackground());
        image.setImage(Images.LOGO_128.image());
        Label title = new Label(composite, 0);
        title.setText(Messages.LabelPortfolioPerformance);
        title.setFont(this.bigFont);
        Label version = new Label(composite, 0);
        version.setText(String.valueOf(PortfolioPlugin.getDefault().getBundle().getVersion().toString()) + " (" + DateTimeFormatter.ofPattern("MMM YYYY").format(BuildInfo.INSTANCE.getBuildTime()) + ")");
        FormDataFactory.startingWith((Control)image).thenRight((Control)title, 30).top(new FormAttachment((Control)image, 0, 128)).thenBelow((Control)version);
    }

    private void createContent(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(20, 20).applyTo(composite);
        this.createLinks(composite);
        this.createRecentFilesComposite(composite);
        this.createTranslationInfo(composite);
    }

    private void createLinks(Composite composite) {
        Composite links = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)links);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(links);
        this.addSectionLabel(this.boldFont, links, Messages.IntroLabelActions);
        this.addLink(links, "action:open", Messages.IntroOpenFile, Messages.IntroOpenFileText);
        this.addLink(links, "action:new", Messages.IntroNewFile, Messages.IntroNewFileText);
        this.addSectionLabel(this.boldFont, links, Messages.IntroLabelSamples);
        this.addLink(links, "action:sample", Messages.IntroOpenSample, Messages.IntroOpenSampleText);
        this.addLink(links, "action:daxsample", Messages.IntroOpenDaxSample, Messages.IntroOpenDaxSampleText);
        this.addSectionLabel(this.boldFont, links, Messages.IntroLabelHelp);
        this.addLink(links, "https://forum.portfolio-performance.info/t/sunny-neues-nennenswertes/23/last", Messages.SystemMenuNewAndNoteworthy, Messages.IntroNewAndNoteworthyText);
        this.addLink(links, "https://forum.portfolio-performance.info", Messages.IntroOpenForum, Messages.IntroOpenForumText);
        this.addLink(links, "https://forum.portfolio-performance.info/c/how-to", Messages.IntroOpenHowtos, Messages.IntroOpenHowtosText);
        this.addLink(links, "https://forum.portfolio-performance.info/c/faq", Messages.IntroOpenFAQ, Messages.IntroOpenFAQText);
    }

    private void createRecentFilesComposite(Composite actions) {
        this.recentFilesComposite = new Composite(actions, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.recentFilesComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(this.recentFilesComposite);
        this.addSectionLabel(this.boldFont, this.recentFilesComposite, Messages.IntroLabelRecentlyUsedFiles);
        for (String file : this.recentFiles.getRecentFiles()) {
            String name = Path.fromOSString((String)file).lastSegment();
            this.addLink(this.recentFilesComposite, OPEN + file, name, null);
        }
    }

    private void createTranslationInfo(Composite composite) {
        Composite translation = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)translation);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(1).applyTo(translation);
        this.addSectionLabel(this.boldFont, translation, Messages.IntroLabelTranslation);
        StyledLabel text = new StyledLabel(translation, 64);
        text.setText(Messages.IntroLabelTranslationInfo);
        GridDataFactory.fillDefaults().indent(3, 0).hint(400, -1).applyTo((Control)text);
        this.addLink(translation, "action:opensettings", Messages.IntroChangeLanguageInPreferences, null);
        this.addSectionLabel(this.boldFont, translation, Messages.PrefTitleDivvyDiary);
        text = new StyledLabel(translation, 64);
        text.setText(Messages.PrefDescriptionDivvyDiary);
        GridDataFactory.fillDefaults().indent(3, 0).hint(400, -1).applyTo((Control)text);
        this.addLink(translation, "action:opensettings", String.valueOf(Messages.LabelSettings) + "...", null);
    }

    private void addSectionLabel(Font boldFont, Composite actions, String label) {
        Label l = new Label(actions, 0);
        l.setText(label);
        l.setFont(boldFont);
        GridDataFactory.fillDefaults().indent(0, 20).applyTo((Control)l);
    }

    private void addLink(Composite container, final String target, String label, String subtext) {
        Link link = new Link(container, 4);
        link.setText("<a>" + label + "</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomePart.this.linkActivated(target);
            }
        });
        if (subtext != null) {
            Label l = new Label(container, 64);
            l.setText(subtext);
            GridDataFactory.fillDefaults().indent(0, -3).applyTo((Control)l);
        }
    }

    public void linkActivated(String target) {
        if (target.startsWith(OPEN)) {
            String file = target.substring(OPEN.length());
            java.util.Optional<MPart> part = this.partService.getParts().stream().filter(p -> "name.abuchen.portfolio.ui.part.portfolio".equals(p.getElementId())).filter(p -> file.equals(p.getPersistedState().get("file"))).findAny();
            if (part.isPresent()) {
                this.partService.activate(part.get());
            } else {
                this.executeCommand("name.abuchen.portfolio.ui.command.openRecentFile", "name.abuchen.portfolio.ui.param.file", file);
            }
        } else if ("action:open".equals(target)) {
            this.executeCommand("name.abuchen.portfolio.ui.command.open", new String[0]);
        } else if ("action:new".equals(target)) {
            this.executeCommand("name.abuchen.portfolio.ui.command.newclient", new String[0]);
        } else if ("action:sample".equals(target)) {
            this.executeCommand("name.abuchen.portfolio.ui.command.openSample", "name.abuchen.portfolio.ui.param.samplefile", "/" + this.getClass().getPackage().getName().replace('.', '/') + "/kommer.xml");
        } else if ("action:daxsample".equals(target)) {
            this.executeCommand("name.abuchen.portfolio.ui.command.openSample", "name.abuchen.portfolio.ui.param.samplefile", "/" + this.getClass().getPackage().getName().replace('.', '/') + "/dax.xml");
        } else if ("action:opensettings".equals(target)) {
            this.executeCommand("org.eclipse.ui.window.preferences", new String[0]);
        } else if (target.startsWith("http")) {
            DesktopAPI.browse(target);
        }
    }

    private void executeCommand(String command, String ... parameters) {
        try {
            ParameterizedCommand pCmd;
            Command cmd = this.commandService.getCommand(command);
            ArrayList<Parameterization> parameterizations = new ArrayList<Parameterization>();
            if (parameters != null) {
                int ii = 0;
                while (ii < parameters.length) {
                    IParameter p = cmd.getParameter(parameters[ii]);
                    parameterizations.add(new Parameterization(p, parameters[ii + 1]));
                    ii += 2;
                }
            }
            if (this.handlerService.canExecute(pCmd = new ParameterizedCommand(cmd, parameterizations.toArray(new Parameterization[0])))) {
                this.handlerService.executeHandler(pCmd);
            }
        }
        catch (NotDefinedException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getMessage());
        }
    }

    @Inject
    @Optional
    public void subscribeFileTopic(@UIEventTopic(value="file/*") String file) {
        if (this.recentFilesComposite == null) {
            return;
        }
        Composite parent = this.recentFilesComposite.getParent();
        this.recentFilesComposite.dispose();
        this.createRecentFilesComposite(parent);
        this.recentFilesComposite.getParent().layout(true);
    }
}

