/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.CurrencyToStringConverter;
import name.abuchen.portfolio.ui.util.DatePicker;
import name.abuchen.portfolio.ui.util.SimpleDateTimeDateSelectionProperty;
import name.abuchen.portfolio.ui.util.StringToCurrencyConverter;
import name.abuchen.portfolio.util.Isin;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BindingHelper {
    private Model model;
    private ModelStatusListener listener = new ModelStatusListener();
    private DataBindingContext context;
    private double averageCharWidth = -1.0;

    public BindingHelper(Model model) {
        this.model = model;
        this.context = new DataBindingContext();
        IObservableValue observable = PojoProperties.value((String)"status").observe((Object)this.listener);
        this.context.bindValue(observable, (IObservableValue)new AggregateValidationStatus(this.context, 2));
    }

    public void onValidationStatusChanged(IStatus status) {
    }

    public DataBindingContext getBindingContext() {
        return this.context;
    }

    public final void createErrorLabel(Composite editArea) {
        Label errorLabel = new Label(editArea, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)errorLabel);
        ISWTObservableValue statusTarget = WidgetProperties.text().observe((Widget)errorLabel);
        AggregateValidationStatus statusModel = new AggregateValidationStatus(this.context, 2);
        this.context.bindValue((IObservableValue)statusTarget, (IObservableValue)statusModel, null, new UpdateValueStrategy().setConverter((IConverter)new StatusTextConverter()));
    }

    public final void createLabel(Composite editArea, String text) {
        Label lblTransactionType = new Label(editArea, 0);
        lblTransactionType.setText(text);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)lblTransactionType);
    }

    public final void bindLabel(Composite editArea, String property) {
        Label label = new Label(editArea, 0);
        IObservableValue labelModel = BeanProperties.value((String)property).observe((Object)this.model);
        ISWTObservableValue labelTarget = WidgetProperties.text().observe((Widget)label);
        this.context.bindValue((IObservableValue)labelTarget, labelModel);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)label);
    }

    public final void bindSpinner(Composite editArea, String label, String property, int min, int max, int increment) {
        Label l = new Label(editArea, 0);
        l.setText(label);
        Spinner spinner = new Spinner(editArea, 2048);
        spinner.setMinimum(min);
        spinner.setMaximum(max);
        spinner.setIncrement(increment);
        GridDataFactory.fillDefaults().align(1, 4).hint((int)Math.round(5.0 * this.getAverageCharWidth((Control)spinner)), -1).applyTo((Control)spinner);
        IObservableValue spinnerModel = BeanProperties.value((String)property).observe((Object)this.model);
        ISWTObservableValue spinnerTarget = WidgetProperties.spinnerSelection().observe((Widget)spinner);
        this.context.bindValue((IObservableValue)spinnerTarget, spinnerModel);
    }

    public final ComboViewer bindCurrencyCodeCombo(Composite editArea, String label, String property) {
        return this.bindCurrencyCodeCombo(editArea, label, property, true);
    }

    public final ComboViewer bindCurrencyCodeCombo(Composite editArea, String label, String property, boolean includeEmpty) {
        Label l = new Label(editArea, 0);
        l.setText(label);
        ComboViewer combo = new ComboViewer(editArea, 8);
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ArrayList<CurrencyUnit> currencies = new ArrayList<CurrencyUnit>();
        if (includeEmpty) {
            currencies.add(CurrencyUnit.EMPTY);
        }
        currencies.addAll(CurrencyUnit.getAvailableCurrencyUnits().stream().sorted().collect(Collectors.toList()));
        combo.setInput(currencies);
        GridDataFactory.fillDefaults().align(1, 4).applyTo(combo.getControl());
        UpdateValueStrategy targetToModel = new UpdateValueStrategy();
        targetToModel.setConverter((IConverter)new CurrencyUnitToStringConverter());
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new StringToCurrencyUnitConverter());
        IObservableValue comboModel = BeanProperties.value((String)property, String.class).observe((Object)this.model);
        IViewerObservableValue comboTarget = ViewerProperties.singleSelection(CurrencyUnit.class).observe((Viewer)combo);
        this.context.bindValue((IObservableValue)comboTarget, comboModel, targetToModel, modelToTarget);
        return combo;
    }

    public final ComboViewer bindCalendarCombo(Composite editArea, String label, String property) {
        Label l = new Label(editArea, 0);
        l.setText(label);
        ComboViewer combo = new ComboViewer(editArea, 8);
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        TradeCalendar emptyOption = TradeCalendarManager.createInheritDefaultOption();
        ArrayList<TradeCalendar> calendar = new ArrayList<TradeCalendar>();
        calendar.add(emptyOption);
        calendar.addAll(TradeCalendarManager.getAvailableCalendar().sorted().collect(Collectors.toList()));
        combo.setInput(calendar);
        GridDataFactory.fillDefaults().align(1, 4).applyTo(combo.getControl());
        UpdateValueStrategy targetToModel = new UpdateValueStrategy();
        targetToModel.setConverter((IConverter)new CalendarToStringConverter());
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new StringToCalendarConverter(emptyOption));
        IViewerObservableValue targetObservable = ViewerProperties.singleSelection(TradeCalendar.class).observe((Viewer)combo);
        IObservableValue observable = BeanProperties.value((String)property, String.class).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetObservable, observable, targetToModel, modelToTarget);
        return combo;
    }

    public final Control bindDatePicker(Composite editArea, String label, String property) {
        Label l = new Label(editArea, 0);
        l.setText(label);
        DatePicker boxDate = new DatePicker(editArea);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo(boxDate.getControl());
        ISWTObservableValue targetObservable = new SimpleDateTimeDateSelectionProperty().observe((Widget)boxDate.getControl());
        IObservableValue modelObservable = BeanProperties.value((String)property, LocalDate.class).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetObservable, modelObservable, new UpdateValueStrategy().setAfterConvertValidator(value -> value != null ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, label))), null);
        return boxDate.getControl();
    }

    public final Control bindMandatoryAmountInput(Composite editArea, String label, String property, int style, int lenghtInCharacters) {
        Text txtValue = this.createTextInput(editArea, label, style, lenghtInCharacters);
        this.bindMandatoryDecimalInput(label, property, txtValue, Values.Amount);
        return txtValue;
    }

    public final Control bindMandatoryQuoteInput(Composite editArea, String label, String property) {
        Text txtValue = this.createTextInput(editArea, label);
        this.bindMandatoryDecimalInput(label, property, txtValue, (Values<?>)Values.Quote);
        return txtValue;
    }

    private void bindMandatoryDecimalInput(String label, String property, Text txtValue, Values<?> type) {
        StringToCurrencyConverter converter = new StringToCurrencyConverter(type);
        UpdateValueStrategy input2model = new UpdateValueStrategy();
        input2model.setAfterGetValidator((IValidator)converter);
        input2model.setConverter((IConverter)converter);
        input2model.setAfterConvertValidator(v -> v != null && v > 0L ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, label)));
        ISWTObservableValue targetObservable = WidgetProperties.text((int)24).observe((Widget)txtValue);
        IObservableValue modelObservable = BeanProperties.value((String)property, Long.class).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetObservable, modelObservable, input2model, new UpdateValueStrategy().setConverter((IConverter)new CurrencyToStringConverter(type)));
    }

    private Text createTextInput(Composite editArea, String label) {
        return this.createTextInput(editArea, label, 0, -1);
    }

    private Text createTextInput(Composite editArea, String label, int style, int lenghtInCharacters) {
        Label l = new Label(editArea, 0);
        l.setText(label);
        final Text txtValue = new Text(editArea, 0x800 | style);
        txtValue.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                txtValue.selectAll();
            }
        });
        if (lenghtInCharacters == -1) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)txtValue);
        } else {
            GridDataFactory.fillDefaults().align(1, 4).hint((int)Math.round((double)(lenghtInCharacters + 5) * this.getAverageCharWidth((Control)txtValue)), -1).applyTo((Control)txtValue);
        }
        return txtValue;
    }

    public final Text bindStringInput(Composite editArea, String label, String property) {
        return this.bindStringInput(editArea, label, property, 0, -1);
    }

    public final IObservableValue<String> bindStringInput(Composite editArea, String label, String property, int style) {
        Text txtValue = this.createTextInput(editArea, label, style, -1);
        ISWTObservableValue targetObservablebserveText = WidgetProperties.text((int)24).observe((Widget)txtValue);
        IObservableValue modelObeservable = BeanProperties.value((String)property, String.class).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetObservablebserveText, modelObeservable);
        return targetObservablebserveText;
    }

    public final Text bindStringInput(Composite editArea, String label, String property, int style, int lenghtInCharacters) {
        Text txtValue = this.createTextInput(editArea, label, style, lenghtInCharacters);
        ISWTObservableValue observeText = WidgetProperties.text((int)24).observe((Widget)txtValue);
        this.context.bindValue((IObservableValue)observeText, BeanProperties.value((String)property).observe((Object)this.model));
        return txtValue;
    }

    public final Text bindISINInput(Composite editArea, String label, String property) {
        Text txtValue = this.createTextInput(editArea, label, 0, 12);
        txtValue.setTextLimit(12);
        ISWTObservableValue targetObservable = WidgetProperties.text((int)24).observe((Widget)txtValue);
        IObservableValue modelObservable = BeanProperties.value((String)property, String.class).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetObservable, modelObservable, new UpdateValueStrategy().setAfterConvertValidator(v -> v == null || v.trim().length() == 0 || Isin.isValid((String)v) ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogNotAValidISIN, label))), null);
        return txtValue;
    }

    public final Control bindBooleanInput(Composite editArea, String label, String property) {
        Label l = new Label(editArea, 0);
        l.setText(label);
        Button btnCheckbox = new Button(editArea, 32);
        ISWTObservableValue targetObservable = WidgetProperties.buttonSelection().observe((Widget)btnCheckbox);
        IObservableValue modelObservable = BeanProperties.value((String)property).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        return btnCheckbox;
    }

    private double getAverageCharWidth(Control control) {
        if (this.averageCharWidth > 0.0) {
            return this.averageCharWidth;
        }
        GC gc = new GC((Drawable)control);
        FontMetrics fm = gc.getFontMetrics();
        this.averageCharWidth = fm.getAverageCharacterWidth();
        gc.dispose();
        return this.averageCharWidth;
    }

    private static final class CalendarToStringConverter
    implements IConverter<TradeCalendar, String> {
        private CalendarToStringConverter() {
        }

        public Object getToType() {
            return String.class;
        }

        public Object getFromType() {
            return TradeCalendar.class;
        }

        public String convert(TradeCalendar fromObject) {
            return fromObject.getCode().isEmpty() ? null : fromObject.getCode();
        }
    }

    private static final class CurrencyUnitToStringConverter
    implements IConverter<CurrencyUnit, String> {
        private CurrencyUnitToStringConverter() {
        }

        public Object getToType() {
            return String.class;
        }

        public Object getFromType() {
            return CurrencyUnit.class;
        }

        public String convert(CurrencyUnit fromObject) {
            return CurrencyUnit.EMPTY.equals((Object)fromObject) ? null : fromObject.getCurrencyCode();
        }
    }

    public static abstract class Model {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private Client client;

        public Model() {
        }

        public Model(Client client) {
            this.client = client;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        public Client getClient() {
            return this.client;
        }

        protected void firePropertyChange(String attribute, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(attribute, oldValue, newValue);
        }

        protected void firePropertyChange(String attribute, long oldValue, long newValue) {
            this.propertyChangeSupport.firePropertyChange(attribute, oldValue, newValue);
        }

        public abstract void applyChanges();
    }

    class ModelStatusListener {
        ModelStatusListener() {
        }

        public void setStatus(IStatus status) {
            BindingHelper.this.onValidationStatusChanged(status);
        }

        public IStatus getStatus() {
            return ValidationStatus.ok();
        }
    }

    private static final class StatusTextConverter
    implements IConverter<IStatus, String> {
        private StatusTextConverter() {
        }

        public Object getToType() {
            return String.class;
        }

        public Object getFromType() {
            return IStatus.class;
        }

        public String convert(IStatus fromObject) {
            return fromObject.isOK() ? "" : fromObject.getMessage();
        }
    }

    private static final class StringToCalendarConverter
    implements IConverter<String, TradeCalendar> {
        private TradeCalendar emptyOption;

        public StringToCalendarConverter(TradeCalendar emptyOption) {
            this.emptyOption = emptyOption;
        }

        public Object getToType() {
            return TradeCalendar.class;
        }

        public Object getFromType() {
            return String.class;
        }

        public TradeCalendar convert(String fromObject) {
            return fromObject == null ? this.emptyOption : TradeCalendarManager.getInstance((String)fromObject);
        }
    }

    private static final class StringToCurrencyUnitConverter
    implements IConverter<String, CurrencyUnit> {
        private StringToCurrencyUnitConverter() {
        }

        public Object getToType() {
            return CurrencyUnit.class;
        }

        public Object getFromType() {
            return String.class;
        }

        public CurrencyUnit convert(String fromObject) {
            return fromObject == null ? CurrencyUnit.EMPTY : CurrencyUnit.getInstance((String)fromObject);
        }
    }
}

