/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import name.abuchen.portfolio.money.Values;
import org.eclipse.core.databinding.conversion.IConverter;

public class CurrencyToStringConverter
implements IConverter<Long, String> {
    private final double factor;
    private final NumberFormat format;

    public CurrencyToStringConverter(Values<?> type) {
        this.factor = type.divider();
        this.format = new DecimalFormat(type.pattern());
    }

    public Object getFromType() {
        return Long.TYPE;
    }

    public Object getToType() {
        return String.class;
    }

    public String convert(Long fromObject) {
        return this.format.format((double)fromObject.longValue() / this.factor);
    }
}

