/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.util.function.Supplier;
import name.abuchen.portfolio.ui.util.SWTHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class InfoToolTip
extends ToolTip {
    private Control control;
    private Supplier<String> message;

    private InfoToolTip(Control control, Supplier<String> message) {
        super(control, 2, false);
        this.control = control;
        this.message = message;
    }

    public static void attach(Control control, String message) {
        InfoToolTip.attach(control, () -> message);
    }

    public static void attach(Control control, Supplier<String> message) {
        InfoToolTip tooltip = new InfoToolTip(control, message);
        tooltip.setPopupDelay(0);
        tooltip.activate();
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        parent.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"tooltip");
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        int maximumWidth = SWTHelper.stringWidth((Drawable)result, "ABCDEFGHIJK") * 5;
        int actualWidth = SWTHelper.stringWidth((Drawable)result, this.message.get()) + layout.marginWidth * 2;
        int widthHint = Math.min(maximumWidth, actualWidth);
        Text text = new Text(result, 64);
        text.setText(this.message.get());
        GridData gridData = new GridData();
        gridData.widthHint = widthHint;
        text.setLayoutData((Object)gridData);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public Point getLocation(Point tipSize, Event event) {
        Point location = this.control.getLocation();
        return this.control.getParent().toDisplay(location.x, location.y + this.control.getSize().y + 5);
    }
}

