/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class QuotesTableViewer {
    private TableViewer tableViewer;

    public QuotesTableViewer(Composite container) {
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(container, 2048);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        viewerColumn.getColumn().setText(Messages.ColumnDate);
        layout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(80, true));
        ColumnViewerSorter.create(element -> element instanceof String ? LocalDate.now() : ((LatestSecurityPrice)element).getDate()).attachTo((ColumnViewer)this.tableViewer, (ViewerColumn)viewerColumn, 128);
        TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnDaysHigh);
        column.setAlignment(131072);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnDaysLow);
        column.setAlignment(131072);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnQuote);
        column.setAlignment(131072);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnVolume);
        column.setAlignment(131072);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PriceLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    public void setInput(List<LatestSecurityPrice> quotes) {
        this.tableViewer.setInput(quotes);
    }

    public void setMessage(String message) {
        this.tableViewer.setInput((Object)new String[]{message});
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void refresh(boolean updateLabels) {
        this.tableViewer.refresh(updateLabels);
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public Widget getControl() {
        return this.tableViewer.getControl();
    }

    static class PriceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PriceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return columnIndex == 0 ? element.toString() : null;
            }
            LatestSecurityPrice p = (LatestSecurityPrice)element;
            switch (columnIndex) {
                case 0: {
                    return Values.Date.format((Object)p.getDate());
                }
                case 1: {
                    return p.getHigh() == -1L ? null : Values.Quote.format(Long.valueOf(p.getHigh()));
                }
                case 2: {
                    return p.getLow() == -1L ? null : Values.Quote.format(Long.valueOf(p.getLow()));
                }
                case 3: {
                    return Values.Quote.format(Long.valueOf(p.getValue()));
                }
                case 4: {
                    return p.getVolume() == -1L ? null : String.format("%,d", p.getVolume());
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex));
        }
    }
}

