/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.extensions.Preference;
import org.osgi.service.prefs.BackingStoreException;

@Creatable
@Singleton
public class RecentFilesCache {
    @Inject
    @Preference
    IEclipsePreferences preferences;
    private static final int MAXIMUM = 10;
    private final Set<String> files = Collections.newSetFromMap(new LinkedHashMap<String, Boolean>(32, 0.7f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 10;
        }
    });

    @PostConstruct
    public void load() {
        String pref = this.preferences.get("RECENT_FILES", "");
        if (!pref.isEmpty()) {
            this.files.addAll(Arrays.asList(pref.split(File.pathSeparator)));
        }
    }

    @PreDestroy
    public void save() {
        try {
            this.preferences.put("RECENT_FILES", String.join((CharSequence)File.pathSeparator, this.files));
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            PortfolioPlugin.log(e);
        }
    }

    @Inject
    @Optional
    public void onFileOpened(@EventTopic(value="file/opened") String file) {
        this.files.add(file);
    }

    @Inject
    @Optional
    public void onFileSaved(@EventTopic(value="file/saved") String file) {
        this.files.add(file);
    }

    @Inject
    @Optional
    public void onFileRemoved(@EventTopic(value="file/removed") String file) {
        this.files.remove(file);
    }

    public List<String> getRecentFiles() {
        ArrayList<String> answer = new ArrayList<String>(this.files);
        Collections.reverse(answer);
        return answer;
    }

    public void clearRecentFiles() {
        this.files.clear();
    }
}

